/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIntroduceTypeDefIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false);
        if (declarator == null) {
            return false;
        }
        OCDeclaration declaration2 = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class, (boolean)false);
        if (declaration2 == null || declaration2 instanceof OCFunctionDefinition || declaration2 instanceof OCParameterDeclaration) {
            return false;
        }
        if (declarator.getParameterList() != null) {
            return false;
        }
        List<OCDeclarator> declarators = declaration2.getDeclarators();
        if (declarators.size() == 0 || declarators.size() > 1) {
            return false;
        }
        OCType type2 = declarator.getType();
        if (declarator.getName() != null && OCIntroduceTypeDefIntentionAction.isComplexType(type2, false, false)) {
            this.setText("Introduce typedef for type " + type2.getBestNameInContext(element));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false);
        if (declarator != null) {
            String name = declarator.getName();
            if (declarator.getParent() instanceof OCDeclaration) {
                OCDeclaration declaration2 = (OCDeclaration)declarator.getParent();
                OCDeclaration typedefDeclaration = (OCDeclaration)declaration2.copy();
                PsiFile psiFile = element.getContainingFile();
                PsiElement typedef = OCElementFactory.typeElementFromText("typedef int", (PsiElement)psiFile).getFirstChild();
                typedefDeclaration.addBefore(typedef.getNextSibling(), typedefDeclaration.getFirstChild());
                typedefDeclaration.addBefore(typedef, typedefDeclaration.getFirstChild());
                OCChangeUtil.addBefore((PsiElement)psiFile, typedefDeclaration, declaration2);
                OCTypeElement type2 = OCElementFactory.typeElementFromText(name, declaration2);
                declaration2.replace(OCElementFactory.declarationByNameAndType(name, type2.getType(), declaration2));
            }
        }
    }

    private static boolean isComplexType(@NotNull OCType type2, boolean hasPointer, boolean hasArray) {
        if (type2 instanceof OCPointerType) {
            if (hasArray) {
                return true;
            }
            if (hasPointer) {
                return true;
            }
            return OCIntroduceTypeDefIntentionAction.isComplexType(((OCPointerType)type2).getRefType(), true, hasArray);
        }
        if (type2 instanceof OCReferenceType) {
            return false;
        }
        return type2 instanceof OCFunctionType;
    }

    @NotNull
    public String getFamilyName() {
        return "Introduce Typedef";
    }
}

