/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCProvideStringLocalizationsIntentionAction;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLocalizeStringIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Localize the string";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        OCReferenceElement referenceElement;
        OCLiteralExpression literal = OCLocalizeStringIntentionAction.getStringLiteral(editor, file2);
        if (!OCCodeInsightUtil.isValid(literal)) {
            return false;
        }
        String literalText = OCElementUtil.getStringLiteral(literal);
        if (literalText == null || literalText.isEmpty()) {
            return false;
        }
        OCSendMessageExpression callExpr = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)literal, OCSendMessageExpression.class);
        if (callExpr != null && callExpr.getMessageSelector().equals("localizedStringForKey:value:table:")) {
            return false;
        }
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)literal, OCMacroCall.class);
        return macroCall == null || (referenceElement = macroCall.getMacroReferenceElement()) == null || !referenceElement.getName().startsWith("NSLocalizedString");
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitAllDocuments();
        final OCLiteralExpression literal = OCLocalizeStringIntentionAction.getStringLiteral(editor, file2);
        if (literal == null) {
            return;
        }
        final String text = literal.getEscapedLiteralText();
        OCStringResourceReference reference = new OCStringResourceReference(literal, "Localizable");
        final OCProvideStringLocalizationsIntentionAction action = new OCProvideStringLocalizationsIntentionAction(reference);
        if (!action.checkFilesForWrite()) {
            return;
        }
        new WriteCommandAction(project2, this.getText(), new PsiFile[]{file2}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (action.invokeBool(file2)) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.localize");
                    String prefix = "NSLocalizedString(@\"";
                    String keyText = OCLocalizeStringIntentionAction.getKeyString(text);
                    OCExpression expression2 = OCElementFactory.expressionFromText(prefix + keyText + "\", @\"" + text + "\")", literal);
                    expression2 = (OCExpression)OCChangeUtil.replaceHandlingMacros(literal, expression2);
                    int offset = expression2.getRangeWithMacros().getStartOffset() + prefix.length();
                    editor.getCaretModel().moveToOffset(offset);
                    editor.getSelectionModel().setSelection(offset, offset + keyText.length());
                    OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), OCMacroCall.class);
                    if (macroCall != null) {
                        PsiElement localizedString;
                        PsiReference ref = macroCall.findReferenceAt(offset - macroCall.getTextOffset());
                        PsiElement psiElement = localizedString = ref != null ? ref.resolve() : null;
                        if (localizedString != null) {
                            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                            new OCInplaceRenameHandler().doRename(localizedString, editor, null);
                        }
                    }
                }
            }
        }.execute();
    }

    @NotNull
    public static String getKeyString(@NotNull String text) {
        return text;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static OCLiteralExpression getStringLiteral(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCLiteralExpression.class);
    }
}

