/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareMembersHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveToInterfaceIntentionAction
extends OCDeclareMembersHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Move to interface";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        OCMemberSymbol member = this.locateCandidate(project2, editor, file2);
        return member != null && member.getParent() instanceof OCInterfaceSymbol && OCSearchScope.isInProjectSources(member) && "".equals(((OCClassSymbol)member.getParent()).getCategoryName());
    }

    @Override
    @NotNull
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        OCDeclareActionContext context = super.evaluateActionContext(parent, element);
        context.setTarget(OCDeclareActionContext.Target.INTERFACE);
        return context;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMemberSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected OCMemberSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCMethod method2 = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)at, OCMethod.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
        if (method2 != null) {
            return (OCMemberSymbol)method2.getSymbol();
        }
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
        OCMemberSymbol member = this.locateCandidate(project2, editor, file2);
        return member != null ? (OCClassSymbol)member.getParent() : null;
    }
}

