/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCRemoveUnnecessaryParenthesesIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCParenthesizedExpression expression2 = (OCParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class);
        if (expression2 == null || OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression2.getOperand()) && !(expression2.getParent() instanceof OCParenthesizedExpression)) {
            return false;
        }
        this.setText(this.getFamilyName());
        PsiElement parent = expression2.getParent();
        if (parent instanceof OCParenthesizedExpression) {
            return true;
        }
        OCExpression child = expression2.getOperand();
        if (child instanceof OCParenthesizedExpression || child instanceof OCSendMessageExpression) {
            return true;
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence((OCExpression)parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(child, false))) {
                return true;
            }
            if (parentPrecedence < destPrecedence) {
                return false;
            }
            if (parent instanceof OCBinaryExpression && expression2 == ((OCBinaryExpression)parent).getRight()) {
                return !OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, child);
            }
            return true;
        }
        return true;
    }

    private static boolean isAssignmentInCondition(OCExpression parent) {
        return parent instanceof OCAssignmentExpression && OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(parent), parent);
    }

    @NotNull
    public String getFamilyName() {
        return "Remove Unnecessary Parentheses";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCExpression expression2 = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class);
        if (expression2 == null) {
            return;
        }
        OCExpression parent = expression2;
        OCParenthesizedExpression prevParent = (OCParenthesizedExpression)expression2;
        while (parent instanceof OCParenthesizedExpression) {
            prevParent = (OCParenthesizedExpression)parent;
            parent = parent.getParent();
        }
        while (expression2 instanceof OCParenthesizedExpression) {
            expression2 = ((OCParenthesizedExpression)expression2).getOperand();
        }
        if (OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression2) && expression2.getParent() instanceof OCExpression) {
            expression2 = (OCExpression)expression2.getParent();
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence(parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(expression2, false)) || expression2 instanceof OCSendMessageExpression) {
                OCChangeUtil.replaceHandlingMacros(prevParent, expression2);
            } else if (parentPrecedence < destPrecedence) {
                OCChangeUtil.replaceHandlingMacros(prevParent, OCParenthesesUtils.appendParentheses(expression2));
            } else if (parent instanceof OCBinaryExpression && prevParent == ((OCBinaryExpression)parent).getRight()) {
                if (OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, expression2)) {
                    OCChangeUtil.replaceHandlingMacros(prevParent, OCParenthesesUtils.appendParentheses(expression2));
                } else {
                    OCChangeUtil.replaceHandlingMacros(prevParent, expression2);
                }
            } else {
                OCChangeUtil.replaceHandlingMacros(prevParent, expression2);
            }
        } else {
            OCChangeUtil.replaceHandlingMacros(prevParent, expression2);
        }
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)parent);
    }
}

