/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAttributesList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCReplaceTypeWithAutoIntentionAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile file2 = element.getContainingFile();
        OCDeclaration declaration2 = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration2 == null) {
            return;
        }
        OCReplaceTypeWithAutoIntentionAction.modifyTypeElement(declaration2);
        for (OCDeclarator declarator : declaration2.getDeclarators()) {
            OCReplaceTypeWithAutoIntentionAction.modifyDeclarator(declarator);
        }
        OCReplaceTypeWithAutoIntentionAction.removeExtraWhitespaces(declaration2.getNode());
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, declaration2.getTextRange());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (!OCCompilerHelper.supportsCxxAutoType(file2) || !OCReplaceTypeWithAutoIntentionAction.isAvailableForElement(element)) {
            return false;
        }
        OCDeclaration declaration2 = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration2 == null || declaration2 instanceof OCParameterDeclaration || declaration2.getDeclarators().isEmpty() || !OCReplaceTypeWithAutoIntentionAction.canTransformCodeFragment(declaration2)) {
            return false;
        }
        OCType type2 = declaration2.getDeclarators().get(0).getType();
        if (type2 instanceof OCAutoType) {
            return false;
        }
        OCResolveContext resolveContext = new OCResolveContext(declaration2);
        OCType resolvedType = type2.resolve(resolveContext);
        if (resolvedType instanceof OCCppReferenceType) {
            OCCppReferenceType referenceType = (OCCppReferenceType)resolvedType;
            if (referenceType.isRvalueRef()) {
                return false;
            }
            resolvedType = referenceType.getRefType();
        }
        if (resolvedType.isUnknown()) {
            return false;
        }
        if (OCReplaceTypeWithAutoIntentionAction.insideForeach(declaration2) && OCReplaceTypeWithAutoIntentionAction.canUseAutoInForeach(declaration2, resolvedType, resolveContext) || OCReplaceTypeWithAutoIntentionAction.canUseAuto(declaration2, resolvedType, resolveContext)) {
            this.setText("Replace type with 'auto'");
            return true;
        }
        return false;
    }

    private static boolean canUseAuto(@NotNull OCDeclaration declaration2, @NotNull OCType commonType, @NotNull OCResolveContext resolveContext) {
        List<OCDeclarator> declarators = declaration2.getDeclarators();
        for (OCDeclarator declarator : declarators) {
            OCType declaratorType = OCTypeUtils.getResolvedCppReferencedType(declarator.getType(), resolveContext);
            if (!commonType.equals(declaratorType, false, resolveContext)) {
                return false;
            }
            OCExpression initializer = declarator.getInitializer();
            if (initializer == null) {
                return false;
            }
            OCType initializerType = OCTypeUtils.getResolvedCppReferencedType(initializer.getType(), resolveContext);
            if (OCReplaceTypeWithAutoIntentionAction.areSameTypes(declaratorType, initializerType, resolveContext)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameTypes(@NotNull OCType declaratorType, @NotNull OCType initializerType, @NotNull OCResolveContext resolveContext) {
        if (declaratorType instanceof OCPointerType) {
            if (declaratorType.isCString() && initializerType.isCString()) {
                return true;
            }
            OCType refType = ((OCPointerType)declaratorType).getRefType();
            if (refType instanceof OCFunctionType && refType.equals(initializerType, false, resolveContext)) {
                return true;
            }
        }
        return declaratorType.equals(initializerType, false, resolveContext);
    }

    private static boolean insideForeach(@NotNull OCDeclaration declaration2) {
        OCForeachStatement foreachStatement = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)declaration2, OCForeachStatement.class);
        return foreachStatement != null && PsiTreeUtil.isAncestor((PsiElement)foreachStatement.getVariableDeclaration(), (PsiElement)declaration2, (boolean)false);
    }

    private static boolean canUseAutoInForeach(@NotNull OCDeclaration declaration2, @NotNull OCType declarationType, @NotNull OCResolveContext resolveContext) {
        OCForeachStatement foreachStatement = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)declaration2, OCForeachStatement.class);
        if (foreachStatement == null) {
            return false;
        }
        OCExpression collectionExpression = foreachStatement.getCollectionExpression();
        if (collectionExpression == null) {
            return false;
        }
        OCType collectionType = collectionExpression.getType().resolve(resolveContext);
        OCType elementType = OCCodeInsightUtil.getCollectionElementType(collectionExpression, collectionType);
        if (elementType == null) {
            return false;
        }
        elementType = OCTypeUtils.getCppReferencedType(elementType);
        return OCReplaceTypeWithAutoIntentionAction.areSameTypes(declarationType, elementType, resolveContext);
    }

    private static void modifyTypeElement(@NotNull OCDeclaration declaration2) {
        OCTypeElement typeElement = declaration2.getTypeElement();
        assert (typeElement != null);
        OCResolveContext resolveContext = new OCResolveContext(declaration2);
        OCType declarationType = OCTypeUtils.getCppReferencedType(declaration2.getDeclarators().get(0).getType().resolve(resolveContext));
        boolean autoWasInsert = false;
        ASTNode node = typeElement.getNode();
        for (ASTNode childNode : node.getChildren(null)) {
            IElementType elementType;
            if (OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode) || (elementType = childNode.getElementType()) == OCTokenTypes.CONST_KEYWORD && declarationType.isConst() || elementType == OCTokenTypes.VOLATILE_KEYWORD && declarationType.isVolatile()) continue;
            if (!autoWasInsert) {
                autoWasInsert = true;
                node.addLeaf((IElementType)OCTokenTypes.AUTO_KEYWORD, (CharSequence)"auto", childNode);
            }
            node.removeChild(childNode);
        }
        assert (autoWasInsert);
    }

    private static void modifyDeclarator(@NotNull OCDeclarator declarator) {
        ASTNode childNode;
        IElementType elementType;
        ASTNode[] children2;
        ASTNode node = declarator.getNode();
        ASTNode[] aSTNodeArray = children2 = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int j = 0; j < n && (elementType = (childNode = aSTNodeArray[j]).getElementType()) != OCTokenTypes.EQ; ++j) {
            if (elementType == OCTokenTypes.IDENTIFIER || elementType == OCTokenTypes.AND || OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode)) continue;
            node.removeChild(childNode);
        }
    }

    private static void removeExtraWhitespaces(@NotNull ASTNode node) {
        ASTNode child;
        IElementType elementType;
        ASTNode[] children2;
        ASTNode[] aSTNodeArray = children2 = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int j = 0; j < n && (elementType = (child = aSTNodeArray[j]).getElementType()) != OCTokenTypes.EQ; ++j) {
            if (OCTokenTypes.WHITESPACES.contains(elementType)) {
                PsiElement prevSibling = OCElementUtil.getPrevSiblingOrParentSibling(child.getPsi());
                if (prevSibling == null) continue;
                ASTNode prevSiblingNode = prevSibling.getNode();
                if (!(prevSiblingNode instanceof LeafElement)) {
                    prevSiblingNode = prevSiblingNode.getLastChildNode();
                }
                if (!OCTokenTypes.WHITESPACES.contains(prevSiblingNode.getElementType())) continue;
                node.removeChild(child);
                continue;
            }
            if (child instanceof LeafElement) continue;
            OCReplaceTypeWithAutoIntentionAction.removeExtraWhitespaces(child);
        }
    }

    private static boolean shouldPreserveNode(@NotNull ASTNode node) {
        if (node.getPsi() instanceof OCAttributesList || node.getPsi() instanceof OCMacroCall) {
            return true;
        }
        IElementType elementType = node.getElementType();
        if (OCTokenTypes.WHITESPACES.contains(elementType)) {
            return true;
        }
        if (CommentUtilCore.isComment(node)) {
            return true;
        }
        if (OCTokenTypes.TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        return OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(elementType);
    }

    private static boolean isAvailableForElement(@NotNull PsiElement element) {
        OCDeclaration declaration2 = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration2 == null) {
            return false;
        }
        for (OCDeclarator declarator : declaration2.getDeclarators()) {
            OCExpression initializer = declarator.getInitializer();
            if (initializer == null || !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)element, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private static boolean canTransformCodeFragment(@NotNull PsiElement element) {
        ASTNode childNode;
        IElementType elementType;
        ASTNode[] children2;
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return false;
        }
        ASTNode node = element.getNode();
        ASTNode[] aSTNodeArray = children2 = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int j = 0; j < n && (elementType = (childNode = aSTNodeArray[j]).getElementType()) != OCTokenTypes.EQ; ++j) {
            PsiElement childElement;
            if (OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode) || OCReplaceTypeWithAutoIntentionAction.canTransformCodeFragment(childElement = childNode.getPsi())) continue;
            return false;
        }
        return true;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Replace type with 'auto'";
    }
}

