/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitDeclarationAndAssignmentIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Split into declaration and assignment";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return false;
        }
        OCDeclarator declarator = OCSplitDeclarationAndAssignmentIntentionAction.getDeclarator(editor, file2);
        OCSymbol symbol = declarator != null ? declarator.getSymbol() : null;
        return symbol instanceof OCDeclaratorSymbol && declarator.getInitializer() != null && !(declarator.getInitializer() instanceof OCCompoundInitializer) && !(declarator.getParent().getParent() instanceof OCLambdaIntroducer) && PsiTreeUtil.getParentOfType((PsiElement)declarator, OCBlockStatement.class) != null && !((OCDeclaratorSymbol)symbol).isConst();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCDeclarator declarator = OCSplitDeclarationAndAssignmentIntentionAction.getDeclarator(editor, file2);
        if (declarator == null) {
            return;
        }
        String name = declarator.getName();
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCBlockStatement.class);
        if (block != null) {
            OCExpressionStatement assignment = OCElementUtil.getTextWithMacros(declarator.getParent()).endsWith(";") ? (OCExpressionStatement)OCElementFactory.statementFromText(name + "=0;", declarator, true) : (OCExpressionStatement)((OCForStatement)OCElementFactory.statementFromText("for(" + name + "=0;;);", declarator, true)).getInitializer();
            OCExpression initializer = declarator.getInitializer();
            OCType initializerType = initializer != null ? initializer.getType() : null;
            OCChangeUtil.replaceHandlingMacros(((OCAssignmentExpression)assignment.getExpression()).getSourceExpression(), initializer);
            OCChangeUtil.delete(initializer);
            OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
            if (declarator.getType().getTerminalType() instanceof OCAutoType && typeElement != null && initializerType != null) {
                OCChangeUtil.replaceHandlingMacros(typeElement, OCElementFactory.typeElementFromText(initializerType.getBestNameInContext(declarator), declarator));
            }
            OCStatement declStatement = OCElementFactory.statementFromText(OCElementUtil.getTextWithMacros(declarator.getParent()) + ";", declarator);
            OCChangeUtil.addBefore(block, declStatement, declarator);
            OCChangeUtil.replaceHandlingMacros(PsiTreeUtil.getParentOfType((PsiElement)declarator, OCStatement.class), assignment);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static OCDeclarator getDeclarator(Editor editor, PsiFile file2) {
        OCTypeElement typeElement;
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration && ((OCDeclaration)typeElement.getParent()).getDeclarators().size() == 1) {
            return ((OCDeclaration)typeElement.getParent()).getDeclarators().get(0);
        }
        return declarator;
    }
}

