/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitFunctionIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Split function into declaration and definition";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return false;
        }
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file2);
        return function != null && function.getNamespaceQualifier() == null;
    }

    public void invoke(final @NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        OCFunctionSymbol symbol;
        final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        psiDocumentManager.commitAllDocuments();
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file2);
        OCFunctionSymbol oCFunctionSymbol = symbol = function != null ? function.getSymbol() : null;
        if (symbol == null) {
            return;
        }
        final Document declarationDocument = psiDocumentManager.getDocument(function.getContainingFile());
        if (declarationDocument == null) {
            return;
        }
        final TextRange range = OCSplitFunctionIntentionAction.getBodyRange(function);
        if (range == null) {
            return;
        }
        final OCGenerateUtil.ReplacePosition pos = OCCppDefinitionsUtil.getOutsidePreferredPosition(file2, OCCppDefinitionsUtil.getFunctionParent(symbol), Collections.singletonList(symbol));
        if (pos == null) {
            return;
        }
        final Document definitionDocument = psiDocumentManager.getDocument(pos.file);
        if (definitionDocument == null) {
            return;
        }
        final RangeMarker newLocation = definitionDocument.createRangeMarker(pos.range);
        final String definitionSignature = (OCGenerateUtil.shouldInsertNewLineBefore(definitionDocument.getCharsSequence(), pos.range.getStartOffset()) ? "\n" : "") + OCCallableUtil.functionSignature(OCCallableUtil.removeDeclarationSpecifiers(symbol), OCCallableUtil.getFunctionParentQualifier(symbol, pos.context), pos.context);
        final String bodyText = declarationDocument.getText(range) + (OCGenerateUtil.shouldInsertNewLineAfter(definitionDocument.getCharsSequence(), pos.range.getEndOffset()) ? "\n" : "");
        final Set files = ContainerUtil.set((Object[])new PsiFile[]{file2, pos.file});
        new WriteCommandAction(project2, this.getText(), files.toArray(new PsiFile[files.size()])){

            protected void run(@NotNull Result result2) throws Throwable {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)files)) {
                    return;
                }
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(declarationDocument);
                if (declarationDocument != definitionDocument) {
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(definitionDocument);
                }
                declarationDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)";");
                int definitionOffset = newLocation.getStartOffset();
                definitionDocument.deleteString(newLocation.getStartOffset(), newLocation.getEndOffset());
                RangeMarker signature = definitionDocument.createRangeMarker(definitionOffset, definitionOffset);
                signature.setGreedyToRight(true);
                definitionDocument.insertString(definitionOffset, (CharSequence)definitionSignature);
                signature.setGreedyToRight(false);
                RangeMarker body2 = definitionDocument.createRangeMarker(signature.getEndOffset(), signature.getEndOffset());
                body2.setGreedyToRight(true);
                definitionDocument.insertString(body2.getStartOffset(), (CharSequence)bodyText);
                body2.setGreedyToRight(false);
                psiDocumentManager.commitDocument(definitionDocument);
                OCChangeUtil.reformatTextIfNotInjected(pos.file, signature.getStartOffset(), signature.getEndOffset());
                psiDocumentManager.commitDocument(definitionDocument);
                OCChangeUtil.reformatTextIfNotInjected(pos.file, body2.getStartOffset(), body2.getStartOffset() + 1);
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(pos.file, TextRange.create((int)body2.getStartOffset(), (int)body2.getEndOffset()));
                OCChangeUtil.reformatTextIfNotInjected(pos.file, body2.getEndOffset(), CharArrayUtil.shiftForward((CharSequence)definitionDocument.getCharsSequence(), (int)body2.getEndOffset(), (String)" \t\n"));
                psiDocumentManager.commitDocument(declarationDocument);
                OCFunctionDeclaration func = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)pos.file.findElementAt(signature.getEndOffset()), OCFunctionDeclaration.class);
                PsiElement identifier = func != null ? func.getNameIdentifier() : null;
                EditorHelper.openInEditor((PsiElement)ObjectUtils.notNull((Object)identifier, (Object)pos.file));
                signature.dispose();
                body2.dispose();
            }
        }.execute();
        newLocation.dispose();
    }

    @Nullable
    private static TextRange getBodyRange(@NotNull OCFunctionDefinition function) {
        OCDeclarator lastElementToKeep;
        OCConstructorInitializationList initializationList = function.getConstructorInitializationList();
        if (initializationList != null) {
            PsiElement cur;
            for (cur = initializationList.getPrevSibling(); !(cur == null || OCElementUtil.isElementSignificant(cur) && OCElementUtil.getElementType(cur) != OCTokenTypes.COLON); cur = cur.getPrevSibling()) {
            }
            lastElementToKeep = cur;
        } else {
            lastElementToKeep = function.getDeclarator();
        }
        if (lastElementToKeep == null) {
            return null;
        }
        return TextRange.create((int)OCElementUtil.getRangeWithMacros(lastElementToKeep).getEndOffset(), (int)function.getTextRange().getEndOffset());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected static OCFunctionDefinition getFunction(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, OCFunctionDefinition.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
    }
}

