/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer._OCLexer;
import org.jetbrains.annotations.NotNull;

public class OCLexer
extends FlexAdapter {
    public static final int INITIAL = 0;
    public static final int INITIAL_INSIDE_LINE = 1024;
    public static final int DIRECTIVE_BODY_STATE = 8;
    public static final int PRAGMA_BODY_STATE = 12;
    public static final int INCLUDE_BODY_STATE = 10;
    public static final int MAX_RAW_STRING_PREFIX_LENGTH = 16;

    @NotNull
    public static Lexer createRawLexerForPreprocessor() {
        return new OCLexer(CLanguageKind.OBJ_CPP, false, false);
    }

    public OCLexer(@NotNull OCLanguageKind kind2, boolean highlighting, boolean hasNullabilityFeature) {
        super((FlexLexer)new _OCLexer(null){

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                boolean isInsideLine = initialState == 1024;
                super.reset(buffer, start, end, isInsideLine ? 0 : initialState);
                this.myLogicalLineStartOffset = isInsideLine ? -1 : start;
            }
        });
        _OCLexer base = (_OCLexer)this.getFlex();
        if (kind2.isCpp()) {
            base.allowCPPKeywords();
        }
        if (kind2.isObjC()) {
            base.allowObjCKeywords();
        }
        if (hasNullabilityFeature) {
            base.allowNullabilityKeywords();
        }
        if (highlighting) {
            base.forHighlighting();
        }
    }
}

