/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCMostlySingularMultiUniqueMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoByNameContributor
implements GotoClassContributor {
    private Condition<OCSymbol> myFilter;

    public OCGotoByNameContributor(Condition<OCSymbol> filter, boolean processMembers) {
        this.myFilter = filter;
    }

    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project2, (Object)false)).booleanValue()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Set<String> allSymbolNames = OCGlobalProjectSymbolsCache.getAllSymbolNames(project2);
        OCMostlySingularMultiUniqueMap<String, OCClassSymbol> allCategories = OCGlobalProjectSymbolsCache.getAllCategories(project2);
        ArrayList<String> result2 = new ArrayList<String>(allSymbolNames.size() + allCategories.size());
        result2.addAll(allSymbolNames);
        allCategories.processAllValues((Processor<OCClassSymbol>)((Processor)symbol -> {
            result2.add(symbol.getName() + "+" + symbol.getCategoryName());
            return true;
        }));
        return result2.toArray(new String[result2.size()]);
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project2, boolean includeNonProjectItems) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project2, (Object)false)).booleanValue()) {
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        return this.getSymbolsByName(name, project2, includeNonProjectItems, (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCImplementationSymbol), false);
    }

    public OCSymbol[] getSymbolsByName(String name, Project project2, boolean includeNonProjectItems, Condition<OCSymbol> condition2, boolean isStrict) {
        ArrayList symbols = new ArrayList();
        HashSet implementations = new HashSet();
        GlobalSearchScope scope = OCSearchScope.getGotoSymbolScope(project2, includeNonProjectItems);
        Processor processor2 = ocSymbol -> {
            if (ocSymbol instanceof OCUsingSymbol) {
                return true;
            }
            if (ocSymbol.getKind().isType() && ocSymbol.isPredeclaration()) {
                return true;
            }
            if (ocSymbol instanceof OCForeignSymbol) {
                return true;
            }
            if (ocSymbol.isSynthetic()) {
                return true;
            }
            if (ocSymbol instanceof OCInterfaceSymbol && implementations.contains(ocSymbol.getPresentableName())) {
                return true;
            }
            VirtualFile file2 = ocSymbol.getContainingFile();
            if (file2 != null && this.myFilter.value(ocSymbol) && scope.contains(file2)) {
                symbols.add(ocSymbol);
                if (ocSymbol instanceof OCImplementationSymbol) {
                    implementations.add(ocSymbol.getPresentableName());
                }
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(processor2, condition2, isStrict ? Conditions.alwaysFalse() : Conditions.alwaysTrue());
        int plus = name.indexOf(43);
        if (plus != -1) {
            String className = name.substring(0, plus).trim();
            String categoryName = name.substring(plus + 1).trim();
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, (Processor<OCSymbol>)((Processor)symbol -> !(symbol instanceof OCClassSymbol) || !symbol.getName().equals(className) || orderedProcessor.process((OCSymbol)symbol)), categoryName);
        } else {
            OCGlobalProjectSymbolsCache.processByQualifiedName(project2, orderedProcessor, name);
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, orderedProcessor, name);
        }
        orderedProcessor.finish();
        Object[] result2 = symbols.toArray(new OCSymbol[symbols.size()]);
        Arrays.sort(result2);
        return result2;
    }

    @Nullable
    public String getQualifiedName(NavigationItem symbol) {
        OCQualifiedName qualifiedName;
        if (symbol instanceof OCSymbolHolderVirtualPsiElement) {
            symbol = ((OCSymbolHolderVirtualPsiElement)symbol).getSymbol();
        }
        if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).getQualifier() == null && (qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName()) != null) {
            return qualifiedName.getCanonicalName(true);
        }
        if (symbol instanceof OCSymbol) {
            return ((OCSymbol)symbol).getPresentableName();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "::";
    }
}

