/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Override
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        PsiFile file2;
        PsiFile psiFile = file2 = sourceElement != null ? sourceElement.getContainingFile() : null;
        if (!(file2 instanceof OCFile)) {
            return null;
        }
        ArrayList elements = new ArrayList();
        Collection<? extends OCSymbol> symbols = OCGotoDeclarationHandler.getTargetSymbols(editor, sourceElement, offset);
        for (OCSymbol oCSymbol : symbols) {
            Object element = oCSymbol.locateDefinition();
            int adjustedOffset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), offset);
            if (element == null || OCGotoDeclarationHandler.isInsideElement(element, sourceElement, adjustedOffset)) continue;
            if (element instanceof OCCallable && OCElementUtil.getElementType(file2.findElementAt(offset)) != OCTokenTypes.IDENTIFIER) {
                return null;
            }
            elements.add(element);
        }
        return elements.toArray(new PsiElement[elements.size()]);
    }

    @Contract(value="null,_,_ -> false; _,null,_ -> false")
    private static boolean isInsideElement(@Nullable PsiElement parent, @Nullable PsiElement child, int offset) {
        return parent != null && child != null && parent.getTextRange().contains(offset) && parent.getContainingFile() == child.getContainingFile();
    }

    @Override
    public String getActionText(DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (editor != null && project2 != null) {
            Collection<? extends OCSymbol> symbols;
            PsiElement sourceElement;
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            PsiElement psiElement = sourceElement = file2 instanceof OCFile ? file2.findElementAt(offset) : null;
            if (sourceElement != null && !(symbols = OCGotoDeclarationHandler.getTargetSymbols(editor, sourceElement, offset)).isEmpty() && symbols.iterator().next().isDefinition()) {
                return "Definition";
            }
        }
        return "Declaration";
    }

    private static Collection<? extends OCSymbol> getTargetSymbols(Editor editor, @NotNull PsiElement sourceElement, int offset) {
        OCSymbol symbol;
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags() | 0x1000, offset);
        if (source instanceof OCCppNamespaceQualifier) {
            return OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)source);
        }
        ASTNode node = sourceElement.getNode();
        if (node != null && node.getElementType() == OCTokenTypes.IDENTIFIER && sourceElement.getParent() instanceof OCCppNamespaceQualifier) {
            return OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)sourceElement.getParent());
        }
        OCSymbol oCSymbol = symbol = source instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)source).getSymbol() : null;
        if (symbol == null) {
            return Collections.emptyList();
        }
        if (symbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
            return ((OCResolveOverloadsUtil.OCFunctionGroupSymbol)symbol).getOverloads();
        }
        HashSet result2 = new HashSet();
        boolean insideElement = OCGotoDeclarationHandler.isInsideElement(source, sourceElement, offset);
        if (symbol.isCallable() || insideElement) {
            OCInterfaceSymbol mainInterface;
            OCSendMessageExpression sendMessageExpression;
            OCObjectTypeContext receiverContext;
            PsiReference reference;
            OCSymbol definitionSymbol = null;
            if (symbol instanceof OCMethodSymbol && (reference = TargetElementUtil.findReference(editor, offset)) != null && reference.getElement() instanceof OCSendMessageExpression && (receiverContext = (sendMessageExpression = (OCSendMessageExpression)reference.getElement()).getReceiverContext()) != null) {
                definitionSymbol = receiverContext.getKnownResponder(sendMessageExpression.getMessageSelector(), false);
            }
            if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null && (mainInterface = ((OCClassSymbol)symbol).getMainInterface()) != null) {
                result2.add(mainInterface);
            }
            if (definitionSymbol == null) {
                definitionSymbol = symbol.getDefinitionSymbol();
            }
            if (definitionSymbol == symbol && insideElement) {
                OCSymbol declSymbol;
                OCCppNamespaceQualifier namespaceQualifier = source instanceof OCDeclarator ? ((OCDeclarator)source).getNamespaceQualifier() : null;
                List<Object> parentSymbols = namespaceQualifier != null ? namespaceQualifier.resolveToSymbols() : Collections.emptyList();
                OCSymbol parentSymbol = parentSymbols.size() == 1 ? (OCSymbol)parentSymbols.get(0) : null;
                OCSymbol oCSymbol2 = declSymbol = parentSymbol instanceof OCStructSymbol ? ((OCStructSymbol)parentSymbol).findMember(symbol.getName()) : null;
                if (declSymbol == null) {
                    declSymbol = symbol.getAssociatedSymbol();
                }
                if (!(declSymbol == null || symbol instanceof OCClassSymbol && "".equals(((OCClassSymbol)symbol).getCategoryName()) && !result2.isEmpty())) {
                    result2.add(declSymbol);
                }
                if (symbol instanceof OCMemberSymbol) {
                    OCSymbol relatedSymbol;
                    CommonProcessors.FindFirstProcessor<OCMemberSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMemberSymbol>(){

                        protected boolean accept(OCMemberSymbol memberSymbol) {
                            return !memberSymbol.isDefinition();
                        }
                    };
                    OCSearchUtil.processMembersHierarchy((OCMemberSymbol)symbol, finder, true, false);
                    if (finder.isFound()) {
                        result2.add(finder.getFoundValue());
                    }
                    if ((relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol)) != null) {
                        result2.add(relatedSymbol);
                    }
                }
            } else if (definitionSymbol != null) {
                result2.add(definitionSymbol);
            } else if (symbol instanceof OCMemberSymbol) {
                CommonProcessors.CollectProcessor<OCMemberSymbol> finder = new CommonProcessors.CollectProcessor<OCMemberSymbol>(){

                    protected boolean accept(OCMemberSymbol memberSymbol) {
                        return memberSymbol.isDefinition();
                    }
                };
                OCSearchUtil.processMembersHierarchy((OCMemberSymbol)symbol, finder, false, true);
                result2.addAll(finder.getResults());
            }
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)arg_0 -> OCGotoDeclarationHandler.lambda$getTargetSymbols$0((Set)result2, arg_0)));
        }
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null) {
            Object element = symbol.locateDefinition();
            OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty();
            if (property != null && (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar() || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)element.getParent()).getPropertyRef() == element)) {
                symbol = property;
            }
        }
        if (result2.isEmpty()) {
            result2.add(symbol);
        }
        return result2;
    }

    private static ArrayList<OCSymbol> getSpecializations(OCStructSymbol symbol) {
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        OCSymbol[] predifinition = new OCSymbol[1];
        OCSymbol[] definition = new OCSymbol[1];
        if (symbol.isSpecialization()) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)_symbol -> {
                if (_symbol instanceof OCStructSymbol) {
                    if (((OCStructSymbol)_symbol).isSpecialization()) {
                        if (!_symbol.isPredeclaration()) {
                            result2.add((OCSymbol)_symbol);
                        }
                    } else if (_symbol != symbol) {
                        if (_symbol.isPredeclaration()) {
                            predifinition[0] = _symbol;
                        } else {
                            definition[0] = _symbol;
                        }
                    }
                }
                return true;
            }));
        } else {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)_symbol -> {
                if (_symbol instanceof OCStructSymbol && !((OCStructSymbol)_symbol).isSpecialization() && _symbol != symbol) {
                    if (_symbol.isPredeclaration()) {
                        predifinition[0] = _symbol;
                    } else {
                        definition[0] = _symbol;
                    }
                }
                return true;
            }));
        }
        if (definition[0] != null) {
            result2.add(0, definition[0]);
        } else if (predifinition[0] != null) {
            result2.add(predifinition[0]);
        }
        return result2;
    }

    private static Collection<OCSymbol> getAppropriateNamespaceDeclarations(OCCppNamespaceQualifier source) {
        Collection<OCSymbol> symbols;
        if (source.getParent() instanceof OCReferenceElement) {
            symbols = ((OCReferenceElement)source.getParent()).resolveToOverloadsSymbols();
        } else if (source.getParent() instanceof OCCppNamespaceQualifier) {
            symbols = OCGotoDeclarationHandler.getAppropriateNamespaceDeclarations((OCCppNamespaceQualifier)source.getParent());
        } else {
            return Collections.emptyList();
        }
        HashSet result2 = new HashSet();
        List<OCSymbol> ownSymbols = source.resolveToSymbols();
        for (OCSymbol ownSymbol : ownSymbols) {
            for (OCSymbol child : symbols) {
                if (!(child instanceof OCSymbolWithQualifiedName) || !ownSymbol.equals(((OCSymbolWithQualifiedName)child).getParent())) continue;
                result2.add((Object)ownSymbol);
            }
        }
        return result2;
    }

    private static /* synthetic */ boolean lambda$getTargetSymbols$0(Set result2, OCSymbol symbol1) {
        result2.add(symbol1);
        return true;
    }
}

