/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Producer;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCReparseablePsiElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.impl.OCLazyBlockStatementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Nullable;

public class OCLazyBlockStatementElementType
extends OCReparseablePsiElementType {
    @Nullable
    private static LazyParsingCallback ourGlobalLazyParsingCallback = null;

    public OCLazyBlockStatementElementType() {
        super("LAZY_BLOCK", OCLazyBlockStatementImpl.class);
    }

    public static void setGlobalLazyParsingCallback(@Nullable LazyParsingCallback callback) {
        ourGlobalLazyParsingCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsable(@Nullable ASTNode parent, CharSequence buffer, Language fileLanguage, Project project2) {
        OCFile ocFile;
        PsiFile file2;
        PsiFile psiFile = file2 = parent != null ? parent.getPsi().getContainingFile() : null;
        if (file2 == null) {
            return false;
        }
        int offset = parent.getPsi().getTextRange().getStartOffset();
        OCFile oCFile = ocFile = file2 instanceof OCFile ? (OCFile)file2 : null;
        if (ocFile == null) {
            return false;
        }
        PsiFile psiFile2 = OCParser.partialContextHolder(file2);
        synchronized (psiFile2) {
            OCImmutableInclusionContext baseContext = OCParser.evaluatePartialContext(ocFile, offset);
            OCInclusionContext currentFileContext = baseContext.derive();
            currentFileContext = OCParser.updatePartialContext(parent.getPsi(), currentFileContext);
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, ocFile);
            lexer.start(buffer);
            return OCLazyBlockStatementElementType.isSafeBlock((Producer<IElementType>)((Producer)() -> {
                IElementType token = lexer.getTokenType();
                if (token != null) {
                    lexer.advance();
                }
                return token;
            }), OCTokenTypes.LBRACE, OCTokenTypes.RBRACE) && lexer.getTokenType() == null;
        }
    }

    @Override
    public ASTNode doParse(ASTNode chameleon, PsiBuilder builder) {
        OCParsing parsing = new OCParsing(builder, chameleon.getElementType());
        PsiElement parent = chameleon.getPsi().getContext();
        if (parent instanceof DummyHolder) {
            PsiElement context = parent.getContext();
            PsiElement psiElement = parent = context != null ? context.getContext() : null;
        }
        if (ourGlobalLazyParsingCallback != null) {
            ourGlobalLazyParsingCallback.onParsingLazyBlock(chameleon, builder, parsing);
        }
        parsing.parseCompoundStatement(parent instanceof OCMethod, false);
        return parsing.getTreeBuilt();
    }

    public static boolean isSafeBlock(Producer<IElementType> tokenizer, IElementType openToken, IElementType closeToken) {
        IElementType token = (IElementType)tokenizer.produce();
        if (token != openToken || token instanceof ForeignLeafType) {
            return false;
        }
        int blockScopeLevel = 1;
        int ifdefScopeLevel = 0;
        boolean isSafe = true;
        while (blockScopeLevel > 0) {
            IElementType originalToken = (IElementType)tokenizer.produce();
            token = OCElementUtil.getUnwrappedTokeType(originalToken);
            if (OCTokenTypes.BLOCK_UNSAFE_DIRECTIVES.contains(token)) {
                isSafe = false;
            }
            if (token == openToken) {
                ++blockScopeLevel;
                continue;
            }
            if (token == closeToken) {
                if (--blockScopeLevel != 0 || !(originalToken instanceof ForeignLeafType)) continue;
                isSafe = false;
                continue;
            }
            if (OCTokenTypes.IF_DIRECTIVES.contains(token)) {
                ++ifdefScopeLevel;
                continue;
            }
            if (token == OCTokenTypes.ENDIF_DIRECTIVE) {
                if (--ifdefScopeLevel >= 0) continue;
                isSafe = false;
                continue;
            }
            if (token != null) continue;
            isSafe = false;
            break;
        }
        return isSafe && ifdefScopeLevel == 0;
    }

    public static interface LazyParsingCallback {
        public void onParsingLazyBlock(ASTNode var1, PsiBuilder var2, OCParsing var3);
    }
}

