/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCInjectionListener;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCPsiElementType;
import com.jetbrains.cidr.lang.parser.OCStubElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;

public class OCParserDefinition
implements ParserDefinition {
    private static final NotNullLazyKey<PsiFile, Project> DUMMY_FILE = NotNullLazyKey.create((String)"PARSER_DEFINITION_DUMMY", project2 -> OCParserDefinition.createDummyFile(project2));

    @NotNull
    public Lexer createLexer(Project project2) {
        PsiFile file2 = (PsiFile)DUMMY_FILE.getValue((UserDataHolder)project2);
        OCInclusionContext context = OCInclusionContext.empty(OCLanguageKindCalculator.calculateLanguageKindFast(file2), file2);
        return new OCPreprocessingLexer(context, (OCFile)file2);
    }

    public PsiParser createParser(Project project2) {
        return OCParser.getInstance();
    }

    public IFileElementType getFileNodeType() {
        return OCTokenTypes.OC_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return OCTokenTypes.WHITESPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return OCTokenTypes.COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return OCTokenTypes.ALL_STRINGS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 instanceof OCPsiElementType) {
            return ((OCPsiElementType)type2).createPsi(node);
        }
        if (type2 instanceof OCStubElementType) {
            return ((OCStubElementType)type2).createPsi(node);
        }
        return new ASTWrapperPsiElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        Project project2 = viewProvider.getManager().getProject();
        if (project2.getUserData(OCLanguage.LANGUAGE_SUPPORT_DISABLED) == Boolean.TRUE) {
            return new PsiPlainTextFileImpl(viewProvider);
        }
        if (viewProvider instanceof InjectedFileViewProvider) {
            OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(viewProvider, true, (IElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT);
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)InjectedLanguageUtil.getShreds(viewProvider).getHostPointer().getElement();
            ((OCInjectionListener)project2.getMessageBus().syncPublisher(OCInjectionListener.INJECTION_TOPIC)).didInject(fragment, host);
            return fragment;
        }
        return new OCFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static PsiFile createDummyFile(@NotNull Project project2) {
        CLanguageKind kind2 = CLanguageKind.maxLanguage(project2);
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        String name = "dummy." + kind2.getDefaultSourceExtension();
        return factory.createFileFromText(name, (Language)OCLanguage.getInstance(), (CharSequence)"");
    }
}

