/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;

public class OCCompilerProperty {

    public static enum PropertyKey {
        C_STATIC_ASSERT(PropertyKey.createFeature("c_static_assert")),
        OBJC_ARC(PropertyKey.createFeature("objc_arc")),
        OBJC_DEFAULT_SYNTHESIZE_PROPERTIES(PropertyKey.createFeature("objc_default_synthesize_properties")),
        OBJC_PROPERTY_EXPLICIT_ATOMIC(PropertyKey.createFeature("objc_property_explicit_atomic")),
        OBJC_INSTANCETYPE(PropertyKey.createFeature("objc_instancetype")),
        OBJC_SUBSCRIPTING(PropertyKey.createFeature("objc_subscripting")),
        OBJC_ARRAY_LITERALS(PropertyKey.createFeature("objc_array_literals")),
        OBJC_DICTIONARY_LITERALS(PropertyKey.createFeature("objc_dictionary_literals")),
        OBJC_CLASS_PROPERTY(PropertyKey.createFeature("objc_class_property")),
        NULLABILITY(PropertyKey.createFeature("nullability")),
        CXX_AUTO_TYPE(PropertyKey.createFeature("cxx_auto_type")),
        CXX_OVERRIDE_CONTROL(PropertyKey.createFeature("cxx_override_control")),
        CXX_GENERALIZED_INITIALIZERS(PropertyKey.createFeature("cxx_generalized_initializers")),
        CXX_NULLPTR(PropertyKey.createFeature("cxx_nullptr")),
        CXX_NONSTATIC_MEMBER_INIT(PropertyKey.createFeature("cxx_nonstatic_member_init")),
        CXX_EXCEPTIONS(PropertyKey.createFeature("cxx_exceptions")),
        CXX_CONSTEXPR(PropertyKey.createFeature("cxx_constexpr")),
        CXX_BINARY_LITERALS(PropertyKey.createFeature("cxx_binary_literals")),
        CXX_RETURN_TYPE_DEDUCTION(PropertyKey.createFeature("cxx_return_type_deduction")),
        CXX_GENERIC_LAMBDAS(PropertyKey.createFeature("cxx_generic_lambdas")),
        UNDERLYING_TYPE(PropertyKey.createFeature("underlying_type")),
        __SIZEOF_WCHAR_T__(PropertyKey.createMacroNumTypeSize("__SIZEOF_WCHAR_T__")),
        __SIZEOF_SHORT__(PropertyKey.createMacroNumTypeSize("__SIZEOF_SHORT__")),
        __SIZEOF_INT__(PropertyKey.createMacroNumTypeSize("__SIZEOF_INT__")),
        __SIZEOF_LONG__(PropertyKey.createMacroNumTypeSize("__SIZEOF_LONG__")),
        __SIZEOF_POINTER__(PropertyKey.createMacroNumTypeSize("__SIZEOF_POINTER__")),
        __SIZEOF_LONG_LONG__(PropertyKey.createMacroNumTypeSize("__SIZEOF_LONG_LONG__")),
        __SIZEOF_FLOAT__(PropertyKey.createMacroNumTypeSize("__SIZEOF_FLOAT__")),
        __SIZEOF_DOUBLE__(PropertyKey.createMacroNumTypeSize("__SIZEOF_DOUBLE__")),
        __SIZEOF_LONG_DOUBLE__(PropertyKey.createMacroNumTypeSize("__SIZEOF_LONG_DOUBLE__")),
        __SIZEOF_SIZE_T__(PropertyKey.createMacroNumTypeSize("__SIZEOF_SIZE_T__")),
        __SIZEOF_PTRDIFF_T__(PropertyKey.createMacroNumTypeSize("__SIZEOF_PTRDIFF_T__")),
        ERROR_RETURN_TYPE(PropertyKey.createWarningOption("-Werror=return-type"));

        @NotNull
        private final Pair<PropertyType, String> myKey;

        private static Pair<PropertyType, String> createFeature(String name) {
            return PropertyType.FEATURE.createKey(name);
        }

        private static Pair<PropertyType, String> createMacroNumTypeSize(String name) {
            return PropertyType.MACRO_NUM_TYPE_SIZE.createKey(name);
        }

        private static Pair<PropertyType, String> createWarningOption(String name) {
            return PropertyType.WARNING_OPTION.createKey(name);
        }

        private PropertyKey(Pair<PropertyType, String> key2) {
            this.myKey = key2;
        }

        public boolean isFeature() {
            return this.myKey.first == PropertyType.FEATURE;
        }

        public boolean isMacroSize() {
            return this.myKey.first == PropertyType.MACRO_NUM_TYPE_SIZE;
        }

        public boolean isWarningOption() {
            return this.myKey.first == PropertyType.WARNING_OPTION;
        }

        public String getName() {
            return (String)this.myKey.second;
        }
    }

    private static enum PropertyType {
        FEATURE,
        MACRO_NUM_TYPE_SIZE,
        WARNING_OPTION;


        @NotNull
        public Pair<PropertyType, String> createKey(@NotNull String name) {
            return Pair.create((Object)((Object)this), (Object)name);
        }
    }
}

