/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.modulemap.ModuleMapModules;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCDefaultModuleResolver
extends OCModuleResolver {
    @Override
    protected boolean processImports(@NotNull OCInclusionContext context, @NotNull List<String> moduleNameParts, @NotNull Processor<VirtualFile> headerProcessor) {
        if (moduleNameParts.isEmpty()) {
            return true;
        }
        if (context.hasRootFile()) {
            String frameworkName = moduleNameParts.get(0);
            Project project2 = context.getProject();
            VirtualFile virtualFile = context.getRootFile().getVirtualFile();
            if (virtualFile != null) {
                ModuleMapModules modules;
                ModuleMapModuleSymbol symbol;
                OCResolveRootAndConfiguration configuration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
                OCResolveConfiguration resolveConfiguration = configuration.getConfiguration();
                if (resolveConfiguration != null && (symbol = (modules = ModuleMapManager.getInstance(project2).getModules(resolveConfiguration)).getModule(StringUtil.join(moduleNameParts, (String)"."))) != null) {
                    OCDefaultModuleResolver.processModuleAndItsSubmodules(symbol, headerProcessor);
                    return true;
                }
                AppleFramework framework = OCIncludeHelpers.getFramework(configuration, frameworkName);
                if (framework != null && moduleNameParts.size() == 1) {
                    ContainerUtil.process(framework.getPublicHeadersToInclude(), headerProcessor);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean processModuleAndItsSubmodules(@NotNull ModuleMapModuleSymbol module2, @NotNull Processor<VirtualFile> headerProcessor) {
        Collection<ModuleMapModuleSymbol> submodules = module2.getSubModules().values();
        return OCDefaultModuleResolver.processModule(module2, headerProcessor) && ContainerUtil.process(submodules, submodule -> submodule.isExplicit() || submodule.isInferred() || OCDefaultModuleResolver.processModuleAndItsSubmodules(submodule, headerProcessor));
    }

    public static boolean processModule(@NotNull ModuleMapModuleSymbol module2, @NotNull Processor<VirtualFile> headerProcessor) {
        VirtualFile umbrellaDir;
        VirtualFile file3;
        ModuleMapPathResolver pathResolver = module2.getPathResolver();
        if (module2.getUmbrellaHeader() != null ? (file3 = pathResolver.resolveHeader(module2.getUmbrellaHeader())) != null && !headerProcessor.process((Object)file3) : module2.getUmbrellaDir() != null && (umbrellaDir = pathResolver.resolveDir(module2.getUmbrellaDir())) != null && !ContainerUtil.process((Object[])umbrellaDir.getChildren(), file2 -> {
            if (!file2.isDirectory() && OCFileTypeHelpers.isHeaderFile(file2.getName())) {
                return headerProcessor.process(file2);
            }
            return true;
        })) {
            return false;
        }
        for (String header : module2.getHeaders()) {
            VirtualFile file4 = pathResolver.resolveHeader(header);
            if (file4 == null || headerProcessor.process((Object)file4)) continue;
            return false;
        }
        return true;
    }
}

