/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInitialInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCInclusionContext
extends OCImmutableInclusionContext {
    public static final Key<Integer> MAX_INCLUSION_LEVEL_KEY = Key.create((String)"MAX_INCLUSION_LEVE_KEY");

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind();

    public OCInclusionContext setRootFile(@Nullable PsiFile var1);

    public void addProcessedFile(@NotNull VirtualFile var1);

    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable var1);

    public void setProcessingListener(@Nullable Processor<OCSymbol> var1);

    public void setChangeBuilder(@Nullable OCContextChangeBuilder var1);

    public void setPrecompiledHeaders(@NotNull List<OCFile> var1);

    public void localDefine(@NotNull String var1, @NotNull String var2);

    @NotNull
    public Map<String, OCMacroSymbol> getSubstitutions();

    public boolean isInitial();

    @NotNull
    public OCParsingNameScope getNameScope();

    @NotNull
    public OCInclusionContext deriveButDontCopyTypes(boolean var1);

    public void define(@NotNull OCMacroSymbol var1);

    public void define(String var1, String var2);

    public void undef(String var1);

    public void addNeverRedefineMacros(Collection<String> var1);

    public boolean isDefined(@Nullable String var1);

    public void setSignatureBuilder(@Nullable SignatureBuilder var1);

    @Nullable
    public VirtualFile resolveNextPath(@NotNull OCIncludeSymbol.IncludePath var1, @NotNull PsiFile var2);

    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath var1, @NotNull PsiFile var2);

    public boolean reserveInclude(@NotNull VirtualFile var1, boolean var2);

    public void preprocessContextOf(@Nullable PsiFile var1, @Nullable VirtualFile var2);

    public void preprocessInclude(@Nullable PsiFile var1, boolean var2);

    public boolean preprocessInclude(@Nullable PsiFile var1, boolean var2, @Nullable VirtualFile var3, int var4);

    @Contract(value="_, _, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable OCFile var1, @Nullable VirtualFile var2, @Nullable VirtualFile var3, int var4, int var5, int var6, @NotNull List<OCSymbol> var7, @Nullable OCContextChangeSet var8);

    public boolean preprocessInclude(@NotNull PsiFile var1, boolean var2, @Nullable VirtualFile var3, int var4, int var5, @Nullable OCContextChangeSet var6);

    public static int getMaxInclusionLevel(@Nullable Project project2) {
        Integer predefined = project2 != null ? (Integer)project2.getUserData(MAX_INCLUSION_LEVEL_KEY) : null;
        return predefined != null ? predefined : OCInclusionContextImpl.DEFAULT_MAX_INCLUSION_LEVEL;
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file2, @NotNull OCResolveConfiguration configuration) {
        return OCInclusionContext.isPrecompiledHeader(file2, configuration.getProject());
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file2, @NotNull Project project2) {
        return OCInclusionContextImpl.getPCHCache(project2).isPCH(file2);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getBuildConfigurationByPchFile(@Nullable VirtualFile pchFile, @NotNull Project project2) {
        if (pchFile == null) {
            return Collections.emptyList();
        }
        return OCInclusionContextImpl.getPCHCache(project2).getConfigurations(pchFile);
    }

    public static void onPrecompiledContextChange(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        ((SimpleModificationTracker)OCInclusionContextImpl.PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2)).incModificationCount();
        configuration.putUserData((Key)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY, null);
    }

    public static void clearSymbolTableConformanceCache(OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        ((SimpleModificationTracker)OCInclusionContextImpl.PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2)).incModificationCount();
        configuration.putUserData((Key)OCInclusionContextImpl.INCLUDE_RESOLVE_CACHE, null);
    }

    @NotNull
    public static OCInclusionContext empty(@NotNull OCLanguageKind kind2, @NotNull PsiFile file2) {
        return new OCInclusionContextImpl(null, file2.getProject(), kind2).setRootFile(file2);
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCFile file2) {
        OCResolveConfiguration configuration = OCInclusionContextUtil.getActiveConfiguration(file2);
        return configuration == null ? OCInclusionContextImpl.emptyWithBuiltinMacros(file2.getKind(), file2) : OCInclusionContext.beforePCHFileContext(configuration, file2.getKind(), file2);
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind2, @NotNull PsiFile file2) {
        return OCInclusionContext.initialContextWithoutRoot(configuration, kind2, file2).derive(file2);
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind2, @NotNull PsiFile file2) {
        return OCInclusionContext.initialPCHContextWithoutRoot(configuration, kind2, file2).derive(file2);
    }

    @NotNull
    public static OCImmutableInclusionContext initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind2, @NotNull PsiFile file2) {
        ConcurrentHashMap switches2context = (ConcurrentHashMap)((Couple)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).first;
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        Pair<String, CidrCompilerSwitches> keys = configuration.getCompilerSettings().getCompilerKeyAndSwitches(kind2, virtualFile);
        OCImmutableInclusionContext context = (OCImmutableInclusionContext)switches2context.get(keys.first);
        if (context != null) {
            return context;
        }
        OCInitialInclusionContext ret = new OCInitialInclusionContext((CidrCompilerSwitches)keys.second, configuration, configuration.getProject(), kind2);
        configuration.getCompilerMacros().fillContext(ret, file2);
        OCImmutableInclusionContext existing = switches2context.putIfAbsent(keys.first, ret);
        return existing == null ? ret : existing;
    }

    @NotNull
    public static OCImmutableInclusionContext initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind2, @NotNull PsiFile file2) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (!kind2.supportsPrecompiledHeaders() || virtualFile == null || OCInclusionContext.isPrecompiledHeader(virtualFile, configuration)) {
            return OCInclusionContext.initialContextWithoutRoot(configuration, kind2, file2);
        }
        ConcurrentHashMap switches2context = (ConcurrentHashMap)((Couple)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).second;
        String key2 = configuration.getCompilerSettings().getCompilerKey(kind2, virtualFile);
        OCImmutableInclusionContext context = (OCImmutableInclusionContext)switches2context.get(key2);
        if (context != null) {
            return context;
        }
        List<OCFile> precompiledHeaders = OCInclusionContextImpl.getPrecompiledHeaders(configuration, kind2, virtualFile);
        if (precompiledHeaders.isEmpty()) {
            return OCInclusionContext.initialContextWithoutRoot(configuration, kind2, file2);
        }
        OCImmutableInclusionContext initial = OCInclusionContext.initialContextWithoutRoot(configuration, kind2, file2);
        OCInclusionContext ctx = initial.derive(file2);
        for (OCFile pch : precompiledHeaders) {
            ctx.preprocessInclude(pch, true);
        }
        ctx.setRootFile(null);
        ctx.setPrecompiledHeaders(precompiledHeaders);
        OCImmutableInclusionContext existing = switches2context.putIfAbsent(key2, ctx);
        return existing == null ? ctx : existing;
    }

    @Nullable
    public static OCImmutableInclusionContext tryFindInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        if (OCInclusionContext.isPrecompiledHeader(pchCandidate, config) && OCImportGraph.getAllRootHeaders(config, pchCandidate, null).contains(header)) {
            return OCInclusionContextImpl.findInCachedPCHPrecompiledContexts(config, header);
        }
        return null;
    }

    @Nullable
    public static String extractFirstPathLiteralText(@NotNull CharSequence contentWithoutMacros) {
        IElementType tt;
        Lexer lexer = OCLexer.createRawLexerForPreprocessor();
        lexer.start(contentWithoutMacros, 0, contentWithoutMacros.length(), 10);
        while (lexer.getState() == 10 && (tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.HEADER_PATH_LITERAL) {
                return lexer.getTokenText();
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static OCIncludeSymbol.IncludePath extractPath(@Nullable CharSequence rawPathLiteralContext, boolean unescapePath) {
        char maybeSuffixPunctuator;
        int length;
        if (rawPathLiteralContext == null || (length = rawPathLiteralContext.length()) < 2) {
            return OCIncludeSymbol.IncludePath.EMPTY;
        }
        int start = 0;
        char prefixPunctuator = rawPathLiteralContext.charAt(0);
        if (prefixPunctuator == '\"' || prefixPunctuator == '<') {
            start = 1;
        }
        if ((maybeSuffixPunctuator = rawPathLiteralContext.charAt(length - 1)) == '\"' && prefixPunctuator == '\"' || maybeSuffixPunctuator == '>' && prefixPunctuator == '<') {
            --length;
        }
        String path = rawPathLiteralContext.subSequence(start, length).toString();
        if (unescapePath) {
            path = path.replace("\\\n", "");
        }
        return new OCIncludeSymbol.IncludePath(path, prefixPunctuator != '\"');
    }

    public static interface SignatureBuilder {
        public void setDefined(@NotNull String var1, boolean var2);

        public void setDefinition(@NotNull String var1, @NotNull OCMacroSymbol var2);

        public void enterConformanceCheckMode();

        public void exitConformanceCheckMode(boolean var1);
    }
}

