/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilderImpl;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerMacros;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInclusionContextImpl
implements OCInclusionContext {
    static int DEFAULT_MAX_INCLUSION_LEVEL = 256;
    @NotNull
    private final OCLanguageKind myLanguageKind;
    private final boolean myNotifyLocalDefinitions;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    @NotNull
    private final Project myProject;
    private THashSet<String> myNeverRedefineMacros = new SmartHashSet();
    @NotNull
    private final Map<String, OCMacroSymbol> mySubstitutions = new THashMap();
    @NotNull
    private final Set<String> myUndefList = new THashSet();
    @NotNull
    private volatile OCParsingNameScope myNameScope;
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new THashSet();
    @Nullable
    private final OCInclusionContextImpl myParentContext;
    private final int myInclusionLevel;
    @Nullable
    private PsiFile myRootFile;
    private volatile List<OCFile> myPrecompiledHeaders;
    @Nullable
    private OCInclusionContext.SignatureBuilder mySignatureBuilder = null;
    private Processor<OCSymbol> myProcessingListener;
    @Nullable
    private OCContextChangeBuilder myChangeBuilder;
    static final NotNullLazyKey<Map<FileSymbolTable, Boolean>, OCResolveConfiguration> INCLUDE_RESOLVE_CACHE = NotNullLazyKey.create((String)"INCLUDE_RESOLVE_CACHE", dom -> ContainerUtil.createConcurrentWeakMap());
    static final NotNullLazyKey<SimpleModificationTracker, Project> PROJECT_MODIFICATION_TRACKER = NotNullLazyKey.create((String)"PROJECT_MODIFICATION_TRACKER", project2 -> new SimpleModificationTracker());
    private static final Key<CachedValue<PCHCache>> PCH_CACHE_KEY = Key.create((String)"PCH_CACHE_KEY");
    static final NotNullLazyKey<Couple<ConcurrentHashMap<String, OCImmutableInclusionContext>>, OCResolveConfiguration> INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY = NotNullLazyKey.create((String)"INITIAL_CONTEXTS_KEY", p -> Couple.of(new ConcurrentHashMap(), new ConcurrentHashMap()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PCHCache getPCHCache(@NotNull Project project2) {
        CachedValue value2 = (CachedValue)project2.getUserData(PCH_CACHE_KEY);
        if (value2 == null) {
            SimpleModificationTracker modificationTracker = (SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2);
            CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)new PCHCache(project2), new Object[]{modificationTracker});
            CachedValue newValue = CachedValuesManager.getManager((Project)project2).createCachedValue(provider2, false);
            value2 = (CachedValue)((UserDataHolderEx)project2).putUserDataIfAbsent(PCH_CACHE_KEY, (Object)newValue);
        }
        if (value2.hasUpToDateValue()) {
            return (PCHCache)value2.getValue();
        }
        CachedValue cachedValue = value2;
        synchronized (cachedValue) {
            return (PCHCache)value2.getValue();
        }
    }

    @NotNull
    static List<OCFile> getPrecompiledHeaders(@NotNull OCResolveConfiguration config, @NotNull OCLanguageKind kind2, @NotNull VirtualFile sourceFile) {
        List<VirtualFile> pchs = config.getPrecompiledHeaders(kind2, sourceFile);
        if (pchs.isEmpty()) {
            return Collections.emptyList();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)config.getProject());
        ArrayList<OCFile> result2 = new ArrayList<OCFile>(pchs.size());
        for (VirtualFile pch : pchs) {
            PsiFile pchPsi;
            if (!pch.isValid() || !((pchPsi = psiManager.findFile(pch)) instanceof OCFile)) continue;
            result2.add((OCFile)pchPsi);
        }
        return result2;
    }

    protected OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCLanguageKind languageKind) {
        assert (configuration == null || project2.equals(configuration.getProject()));
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = languageKind;
        this.myNameScope = new OCParsingNameScope();
        this.myParentContext = null;
        this.myInclusionLevel = 0;
        this.myNotifyLocalDefinitions = false;
    }

    private OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCInclusionContextImpl parentContext, @NotNull PsiFile rootFile, @NotNull OCParsingNameScope nameScope, boolean notifyLocalDefinitions) {
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = parentContext.myLanguageKind;
        this.myParentContext = parentContext;
        this.myRootFile = rootFile;
        this.myNameScope = nameScope;
        this.myInclusionLevel = this.myParentContext.myInclusionLevel + 1;
        this.myNotifyLocalDefinitions = notifyLocalDefinitions;
        Project configurationProject = configuration != null ? configuration.getProject() : null;
        OCLog.LOG.assertTrue(this.myInclusionLevel <= OCInclusionContext.getMaxInclusionLevel(configurationProject) + 2, (Object)"Inclusion level is too high");
    }

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        return this.myLanguageKind;
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file2) {
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.addProcessedFile(file2);
        }
        this.myProcessedFiles.add(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable table) {
        this.enterConformanceCheckMode();
        boolean isCompatibleTable = false;
        try {
            ContextSignature sig = table.getSignature();
            if (sig.isCompatible(this)) {
                isCompatibleTable = this.myConfiguration == null || this.conformsToByIncludes(table);
            }
            boolean bl = isCompatibleTable;
            return bl;
        }
        finally {
            this.exitConformanceCheckMode(isCompatibleTable);
        }
    }

    @Override
    public void setProcessingListener(@Nullable Processor<OCSymbol> processingListener) {
        this.myProcessingListener = processingListener;
    }

    @Override
    public void setChangeBuilder(@Nullable OCContextChangeBuilder changeBuilder) {
        this.myChangeBuilder = changeBuilder;
    }

    @NotNull
    static OCInclusionContext emptyWithBuiltinMacros(@Nullable OCLanguageKind kind2, @NotNull PsiFile file2) {
        if (kind2 == null) {
            kind2 = OCLanguageKindCalculator.calculateLanguageKindFast(file2);
        }
        OCInclusionContext result2 = OCInclusionContext.empty(kind2, file2);
        OCCompilerMacros.BUILT_INS.fillContext(result2, file2);
        return result2;
    }

    private boolean conformsToByIncludes(@NotNull FileSymbolTable table) {
        Map<FileSymbolTable, Boolean> resolveCache = this.getSymbolTablesConformingCache();
        Boolean conforms = resolveCache.get(table);
        if (conforms == null) {
            conforms = table.processIncludes((Processor<OCIncludeSymbol>)((Processor)symbol -> {
                VirtualFile resolved;
                VirtualFile targetFile = symbol.getTargetFile();
                if (targetFile instanceof LightVirtualFileBase) {
                    return true;
                }
                VirtualFile owner = table.getContainingFile();
                OCIncludeSymbol.IncludePath path = symbol.getIncludePath();
                Project project2 = table.getProject();
                OCResolveRootAndConfiguration conf = this.getRootAndConfiguration();
                if (symbol.isNext()) {
                    Ref r = new Ref();
                    OCIncludeHelpers.resolveNextIncludedFile(conf, owner, owner, path, project2, (Ref<VirtualFile>)r);
                    resolved = (VirtualFile)r.get();
                } else {
                    resolved = OCIncludeHelpers.resolveIncludedFile(conf, owner, path, project2);
                }
                return Comparing.equal((Object)targetFile, (Object)resolved);
            }));
            resolveCache.put(table, conforms);
        }
        return conforms;
    }

    @Override
    public int getInclusionLevel() {
        return this.myInclusionLevel;
    }

    @Override
    @Nullable
    public OCImmutableInclusionContext getParent() {
        return this.myParentContext;
    }

    @Override
    public void setPrecompiledHeaders(@NotNull List<OCFile> precompiledHeader) {
        this.myPrecompiledHeaders = new ArrayList<OCFile>(precompiledHeader);
    }

    @Override
    @NotNull
    public List<OCFile> getPrecompiledHeaders() {
        if (this.myPrecompiledHeaders != null && !this.myPrecompiledHeaders.isEmpty()) {
            return Collections.unmodifiableList(this.myPrecompiledHeaders);
        }
        return this.myParentContext == null ? Collections.emptyList() : this.myParentContext.getPrecompiledHeaders();
    }

    @Override
    public boolean hasRootFile() {
        return this.myRootFile != null;
    }

    @Override
    @NotNull
    public PsiFile getRootFile() {
        if (this.myRootFile == null) {
            OCLog.LOG.error("No root file");
        }
        return this.myRootFile;
    }

    @Override
    public OCInclusionContext setRootFile(@Nullable PsiFile file2) {
        if (this.myRootFile != null && file2 != null) {
            throw new IllegalStateException("Trying to change root file for inclusion context with existing root file");
        }
        this.myRootFile = file2;
        return this;
    }

    @Nullable
    static OCImmutableInclusionContext findInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header) {
        Collection values = ((ConcurrentHashMap)((Couple)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)config)).second).values();
        OCImmutableInclusionContext bestContext = null;
        for (OCImmutableInclusionContext each : values) {
            OCLanguageKind eachContextLang = each.getLanguageKind();
            assert (eachContextLang.supportsPrecompiledHeaders());
            if (!each.isProcessed(header)) continue;
            assert (eachContextLang instanceof CLanguageKind);
            if (bestContext != null && bestContext.getLanguageKind() != CLanguageKind.min((CLanguageKind)eachContextLang, (CLanguageKind)bestContext.getLanguageKind())) continue;
            bestContext = each;
        }
        return bestContext;
    }

    private Map<FileSymbolTable, Boolean> getSymbolTablesConformingCache() {
        if (this.myConfiguration == null) {
            return new THashMap();
        }
        return (Map)INCLUDE_RESOLVE_CACHE.getValue((UserDataHolder)this.myConfiguration);
    }

    @Override
    public void localDefine(@NotNull String name, @NotNull String value2) {
        if (this.myConfiguration != null && this.canBeDefined(name)) {
            this.mySubstitutions.put(name, new OCMacroSymbol(this.myConfiguration.getProject(), null, 0, name, null, value2));
        }
    }

    @Override
    @NotNull
    public Map<String, OCMacroSymbol> getSubstitutions() {
        assert (this.isInitial()) : "Operation is only supported for initial context";
        return this.mySubstitutions;
    }

    @Override
    public boolean isInitial() {
        return this.myParentContext == null;
    }

    @Override
    @NotNull
    public OCParsingNameScope getNameScope() {
        return this.myNameScope;
    }

    @Override
    @NotNull
    public OCInclusionContext derive() {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope.copy(), true);
    }

    @Override
    @NotNull
    public OCInclusionContext derive(@NotNull PsiFile file2) {
        if (this.myRootFile != null) {
            throw new IllegalStateException("Deriving from context with existing root file. Use 'derive()' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, file2, this.myNameScope.copy(), true);
    }

    @Override
    @NotNull
    public OCInclusionContext derive(@NotNull OCParsingNameScope nameScope) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, nameScope, true);
    }

    @Override
    @NotNull
    public OCInclusionContext deriveButDontCopyTypes(boolean notifyLocalDefinitions) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope, notifyLocalDefinitions);
    }

    @Override
    public void define(@NotNull OCMacroSymbol def) {
        String name = def.getName();
        if (this.canBeDefined(name)) {
            this.myUndefList.remove(name);
            this.mySubstitutions.put(name, def);
            if (this.myChangeBuilder != null) {
                this.myChangeBuilder.define(name, def);
            }
        }
    }

    @Override
    public void define(String def, String content) {
        this.define(new OCMacroSymbol(this.getProject(), null, 0, def, OCImmutableList.emptyList(), content));
    }

    @Override
    public void undef(String name) {
        if (this.canBeDefined(name)) {
            this.myUndefList.add(name);
            this.mySubstitutions.remove(name);
            if (this.myChangeBuilder != null) {
                this.myChangeBuilder.undef(name);
            }
        }
    }

    private boolean canBeDefined(@Nullable String name) {
        if (name == null) {
            return false;
        }
        if (this.myNeverRedefineMacros.contains((Object)name)) {
            return false;
        }
        return this.myParentContext == null || this.myParentContext.canBeDefined(name);
    }

    @Override
    public void addNeverRedefineMacros(Collection<String> macros) {
        this.myNeverRedefineMacros.addAll(macros);
    }

    @Override
    public boolean isDefined(@Nullable String name) {
        return this.getDefinition(name, OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION) != null;
    }

    @Override
    @NotNull
    public OCLanguageStandard getLanguageStandard() {
        OCLanguageStandard std = OCLanguageStandard.getStandardFromCPLUSPLUS(this.getDefinitionUnprocessedValue("_MSVC_LANG"));
        if (std == OCLanguageStandard.UNKNOWN) {
            std = OCLanguageStandard.getStandardFromCPLUSPLUS(this.getDefinitionUnprocessedValue("__cplusplus"));
        }
        if (std == OCLanguageStandard.UNKNOWN) {
            std = OCLanguageStandard.getStandardFromSTDC(this.getDefinitionUnprocessedValue("__STDC__"), this.getDefinitionUnprocessedValue("__STDC_VERSION__"));
        }
        return std;
    }

    @Override
    public boolean isClangFeatureEnabled(@NotNull String feature) {
        OCMacroSymbol macroSymbol = this.getDefinition(OCCompilerMacros.clangFeature(feature));
        return macroSymbol != null && "1".equals(macroSymbol.getSubstitution());
    }

    @Override
    public boolean isClangExtensionEnabled(@NotNull String feature) {
        OCMacroSymbol macroSymbol = this.getDefinition(OCCompilerMacros.clangExtension(feature));
        return macroSymbol != null && "1".equals(macroSymbol.getSubstitution());
    }

    @Override
    public boolean isClangFeatureOrExtensionEnabled(@NotNull String feature) {
        return this.isClangFeatureEnabled(feature) || this.isClangExtensionEnabled(feature);
    }

    private String getDefinitionUnprocessedValue(@Nullable String id) {
        OCMacroSymbol macro = this.getDefinition(id);
        return macro == null ? null : macro.getSubstitution();
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id) {
        return this.getDefinition(id, OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION);
    }

    private void enterConformanceCheckMode() {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.enterConformanceCheckMode();
        }
        if (this.myParentContext != null) {
            this.myParentContext.enterConformanceCheckMode();
        }
    }

    private void exitConformanceCheckMode(boolean commit) {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.exitConformanceCheckMode(commit);
        }
        if (this.myParentContext != null) {
            this.myParentContext.exitConformanceCheckMode(commit);
        }
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id, @NotNull OCImmutableInclusionContext.SignaturePart sp) {
        OCMacroSymbol answer;
        boolean notify;
        if (id == null) {
            return null;
        }
        boolean bl = notify = sp != OCImmutableInclusionContext.SignaturePart.NO;
        if (this.myUndefList.contains(id)) {
            answer = null;
            notify = this.myNotifyLocalDefinitions;
        } else {
            OCMacroSymbol local = this.mySubstitutions.get(id);
            if (local != null) {
                answer = local;
                notify = this.myNotifyLocalDefinitions;
            } else {
                OCMacroSymbol oCMacroSymbol = answer = this.myParentContext != null ? this.myParentContext.getDefinition(id, sp) : null;
            }
        }
        if (notify && this.mySignatureBuilder != null) {
            switch (sp) {
                case HAS_DEFINITION: {
                    this.mySignatureBuilder.setDefined(id, answer != null);
                    break;
                }
                case EXACT_DEFINITION: {
                    if (answer == null) break;
                    this.mySignatureBuilder.setDefinition(id, answer);
                    break;
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isProcessed(@Nullable VirtualFile file2) {
        return file2 != null && (this.myProcessedFiles.contains(file2) || this.myParentContext != null && this.myParentContext.isProcessed(file2));
    }

    @Override
    @NotNull
    public final Set<VirtualFile> getProcessedFiles() {
        THashSet files = new THashSet();
        this.collectProcessedFile((Set<VirtualFile>)files);
        return Collections.unmodifiableSet(files);
    }

    private void collectProcessedFile(Set<VirtualFile> result2) {
        if (this.myParentContext != null) {
            this.myParentContext.collectProcessedFile(result2);
        }
        result2.addAll(this.myProcessedFiles);
    }

    @Override
    public void setSignatureBuilder(@Nullable OCInclusionContext.SignatureBuilder signatureBuilder) {
        this.mySignatureBuilder = signatureBuilder;
    }

    @Override
    @Nullable
    public VirtualFile resolveNextPath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull PsiFile contextFile) {
        Ref result2 = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(this.getRootAndConfiguration(), OCInclusionContextUtil.getVirtualFile(contextFile), OCInclusionContextUtil.getVirtualFile(contextFile), path, contextFile.getProject(), (Ref<VirtualFile>)result2);
        return (VirtualFile)result2.get();
    }

    @Override
    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull PsiFile contextFile) {
        return OCIncludeHelpers.resolveIncludedFile(this.getRootAndConfiguration(), OCInclusionContextUtil.getVirtualFile(contextFile), path, contextFile.getProject());
    }

    @NotNull
    private OCResolveRootAndConfiguration getRootAndConfiguration() {
        VirtualFile file2 = OCInclusionContextUtil.getVirtualFile(this.myRootFile);
        if (file2 == null) {
            return new OCResolveRootAndConfiguration(this.myConfiguration, this.myLanguageKind);
        }
        return new OCResolveRootAndConfiguration(this.myConfiguration, file2);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public boolean reserveInclude(@NotNull VirtualFile file2, boolean once) {
        if (file2.isValid()) {
            String includeId = OCInclusionContextUtil.inclusionId(file2);
            if (once && this.isDefined(includeId)) {
                return false;
            }
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(file2);
            if (this.isDefined(pragmaOnceId)) {
                return false;
            }
            this.define(OCMacroSymbol.inclusionGuard(includeId));
        }
        return true;
    }

    @Override
    public void preprocessContextOf(@Nullable PsiFile root, @Nullable VirtualFile breakOn) {
        this.preprocessInclude(root, true, breakOn, this.myInclusionLevel);
    }

    @Override
    public void preprocessInclude(@Nullable PsiFile file2, boolean once) {
        this.preprocessInclude(file2, once, null, this.myInclusionLevel);
    }

    @Override
    public boolean preprocessInclude(@Nullable PsiFile file2, boolean once, @Nullable VirtualFile breakOn, int inclusionLevel) {
        if (file2 == null || inclusionLevel >= OCInclusionContext.getMaxInclusionLevel(null)) {
            return true;
        }
        VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (vFile == null || !this.reserveInclude(vFile, once)) {
            return true;
        }
        this.addProcessedFile(vFile);
        FileSymbolTable table = FileSymbolTable.forFile(file2, this);
        if (table != null && file2 instanceof OCFile) {
            return this.preprocessFile((OCFile)file2, vFile, breakOn, inclusionLevel, -1, -1, table.getContents(), null) != null;
        }
        return true;
    }

    @Override
    @Contract(value="_, _, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable OCFile file2, @Nullable VirtualFile vFile, @Nullable VirtualFile breakOn, int inclusionLevel, int afterOffset, int beforeOffset, @NotNull List<OCSymbol> symbols, @Nullable OCContextChangeSet changeSet) {
        class Builder
        implements Processor<OCSymbol> {
            @NotNull
            private OCParsingNameScope myNameScope;
            @Nullable
            private final OCContextChangeBuilder myContextChangeBuilder;
            private boolean wasTruncated;
            final /* synthetic */ OCFile val$file;
            final /* synthetic */ VirtualFile val$vFile;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ int val$inclusionLevel;
            final /* synthetic */ OCContextChangeSet val$changeSet;
            final /* synthetic */ int val$afterOffset;
            final /* synthetic */ int val$beforeOffset;

            public Builder(@Nullable OCParsingNameScope nameScope, OCContextChangeBuilder builder) {
                this.val$file = oCFile;
                this.val$vFile = virtualFile;
                this.val$breakOn = virtualFile2;
                this.val$inclusionLevel = n;
                this.val$changeSet = oCContextChangeSet;
                this.val$afterOffset = n2;
                this.val$beforeOffset = n3;
                this.myNameScope = nameScope;
                this.myContextChangeBuilder = builder;
            }

            public boolean wasTruncated() {
                return this.wasTruncated;
            }

            @NotNull
            public OCParsingNameScope getNameScope() {
                return this.myNameScope;
            }

            public boolean process(OCSymbol symbol) {
                if (OCInclusionContextImpl.this.myProcessingListener != null) {
                    OCInclusionContextImpl.this.myProcessingListener.process((Object)symbol);
                }
                OCContextChangeBuilder changeBuilder = this.myContextChangeBuilder;
                if (symbol instanceof OCIncludeSymbol) {
                    PsiFile psiFile;
                    assert (this.val$file != null);
                    assert (this.val$vFile != null);
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    VirtualFile targetFile = include.getTargetFile();
                    PsiFile psiFile2 = psiFile = targetFile == null || !targetFile.isValid() ? null : this.val$file.getManager().findFile(targetFile);
                    if (psiFile instanceof OCFile) {
                        if (targetFile.equals(this.val$breakOn) || !OCInclusionContextImpl.this.preprocessInclude(psiFile, include.isOnce(), this.val$breakOn, this.val$inclusionLevel + 1, include.getEndOffset(), this.val$changeSet)) {
                            return false;
                        }
                        OCImportGraph.addHeaderIncluder(psiFile.getProject(), targetFile, this.val$vFile);
                    }
                } else if (symbol instanceof OCMacroSymbol) {
                    OCInclusionContextImpl.this.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    OCInclusionContextImpl.this.undef(symbol.getName());
                } else {
                    OCSymbolKind kind2 = symbol.getKind();
                    OCParsingNameScope resultNameScope = this.myNameScope;
                    if (symbol instanceof OCNamespaceSymbol) {
                        OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                        List<OCSymbol> members = namespaceSymbol.getMembersList();
                        Collection usings = namespaceSymbol.getNamespaceUsings();
                        if (members != null || usings != null) {
                            OCSymbol lastMember;
                            OCParsingNameScope inner;
                            if (changeBuilder != null) {
                                changeBuilder.addSymbol(symbol);
                                changeBuilder = null;
                            }
                            if (this.val$afterOffset != -1 && this.val$afterOffset > symbol.getOffset()) {
                                inner = this.myNameScope;
                            } else {
                                inner = this.myNameScope.defineNamespace(symbol.getName());
                                if (symbol instanceof OCStructSymbol) {
                                    for (OCTypeParameterSymbol templateParam : ((OCStructSymbol)symbol).getTemplateParameters()) {
                                        if (templateParam instanceof OCTypeParameterTypeSymbol) {
                                            inner.defineType(templateParam.getName(), true);
                                            continue;
                                        }
                                        if (!(templateParam instanceof OCTypeParameterValueSymbol)) continue;
                                        inner.defineValue(templateParam.getName(), false);
                                    }
                                }
                            }
                            Builder innerProcessor = new Builder(inner, null);
                            namespaceSymbol.processMembersAndUsings((Processor<OCSymbol>)((Processor)member -> {
                                innerProcessor.process((OCSymbol)member);
                                return true;
                            }), this.val$afterOffset, this.val$beforeOffset);
                            OCSymbol oCSymbol = lastMember = members != null ? (OCSymbol)ContainerUtil.getLastItem(members) : null;
                            if (this.val$beforeOffset != -1 && lastMember != null && this.val$beforeOffset <= lastMember.getOffset() || innerProcessor.wasTruncated()) {
                                this.wasTruncated = true;
                                resultNameScope = innerProcessor.getNameScope();
                            } else {
                                OCParsingNameScope scope = innerProcessor.getNameScope();
                                resultNameScope = scope.getParent();
                                OCLog.LOG.assertTrue(resultNameScope != null, (Object)("no parent scope found for '" + symbol.getName() + "' (current scope is '" + scope + "')"));
                            }
                        }
                    }
                    if (symbol instanceof OCUsingSymbol) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                            this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        } else {
                            this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        }
                    } else if (kind2.isType()) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (kind2.isClass()) {
                            if (kind2 == OCSymbolKind.PROTOCOL) {
                                this.myNameScope.defineProtocol(symbol.getName());
                            } else {
                                this.myNameScope.defineInterface(symbol.getName());
                            }
                            if (symbol instanceof OCClassSymbol) {
                                ((OCClassSymbol)symbol).processMembers((String)null, new OCCommonProcessors.SelfAdapterProcessor(this));
                            }
                        } else if (kind2.isClassOrTypedef() || OCInclusionContextImpl.this.myLanguageKind.isCpp()) {
                            boolean isTemplate = symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isTemplateSymbol();
                            boolean isFriendClass = symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriend();
                            this.myNameScope.defineType(symbol.getName(), isTemplate, isFriendClass, -1);
                        }
                        if (kind2 == OCSymbolKind.ENUM && symbol instanceof OCStructSymbol) {
                            ((OCStructSymbol)symbol).processFields((Processor<OCDeclaratorSymbol>)((Processor)symbol1 -> {
                                this.myNameScope.defineValue(symbol1.getName(), false);
                                return true;
                            }));
                        }
                    } else if (symbol instanceof OCInstanceVariableSymbol) {
                        this.myNameScope.defineValue(symbol.getName(), false);
                    } else if (symbol instanceof OCFunctionSymbol && !symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCFunctionSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCDeclaratorSymbol)symbol).isTemplateSymbol());
                    }
                    this.myNameScope = resultNameScope;
                }
                return true;
            }
        }
        Builder builder = new Builder(this.myNameScope, this.myChangeBuilder);
        if (OCResolveUtil.processSymbolsFromList(builder, symbols, afterOffset, beforeOffset)) {
            this.myNameScope = builder.getNameScope();
            return this;
        }
        return null;
    }

    @Override
    public boolean preprocessInclude(@NotNull PsiFile file2, boolean once, @Nullable VirtualFile breakOn, int includeLevel, int offsetAfterInclude, @Nullable OCContextChangeSet changeSet) {
        boolean result2;
        OCContextChangeBuilderImpl builder = null;
        OCContextChange change = null;
        if (changeSet != null && (change = changeSet.getChange(offsetAfterInclude)) == null) {
            builder = new OCContextChangeBuilderImpl(offsetAfterInclude);
            this.setChangeBuilder(builder);
        }
        if (change == null) {
            result2 = this.preprocessInclude(file2, once, breakOn, includeLevel);
        } else {
            change.apply(file2.getProject(), this);
            result2 = true;
        }
        if (builder != null && !this.isProcessed(OCInclusionContextUtil.getVirtualFile(this.myRootFile))) {
            changeSet.setChange(offsetAfterInclude, builder);
            this.setChangeBuilder(null);
        }
        return result2;
    }

    public DeepEqual.Equality<OCInclusionContextImpl> equality() {
        return new DeepEquality();
    }

    private static class DeepEquality
    implements DeepEqual.Equality<OCInclusionContextImpl> {
        private DeepEquality() {
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCInclusionContextImpl first, @NotNull OCInclusionContextImpl second) {
            if (first.myLanguageKind != second.myLanguageKind) {
                return false;
            }
            if (first.myInclusionLevel != second.myInclusionLevel) {
                return false;
            }
            if (!Comparing.equal((Object)first.myRootFile, (Object)second.myRootFile)) {
                return false;
            }
            if (first.myNotifyLocalDefinitions != second.myNotifyLocalDefinitions) {
                return false;
            }
            if (first.myConfiguration != second.myConfiguration) {
                return false;
            }
            if (!first.myNeverRedefineMacros.equals((Object)second.myNeverRedefineMacros)) {
                return false;
            }
            if (!first.myUndefList.equals(second.myUndefList)) {
                return false;
            }
            if (!first.myProcessedFiles.equals(second.myProcessedFiles)) {
                return false;
            }
            if (!Comparing.equal((Object)first.mySignatureBuilder, (Object)second.mySignatureBuilder)) {
                return false;
            }
            if (!c.equalObjects(first.myParentContext, second.myParentContext)) {
                return false;
            }
            if (!c.equalMaps(first.mySubstitutions, second.mySubstitutions)) {
                return false;
            }
            return c.equalObjects(first.myNameScope, second.myNameScope);
        }
    }

    static class PCHCache {
        private final MultiMap<VirtualFile, OCResolveConfiguration> pch2configs = new MultiMap<VirtualFile, OCResolveConfiguration>(){

            @NotNull
            protected Collection<OCResolveConfiguration> createCollection() {
                return ContainerUtil.newLinkedHashSet();
            }
        };

        public PCHCache(@NotNull Project project2) {
            OCWorkspace workspace = OCWorkspaceManager.getWorkspace(project2);
            for (OCResolveConfiguration oCResolveConfiguration : workspace.getConfigurations()) {
                for (VirtualFile pch : oCResolveConfiguration.getPrecompiledHeaders()) {
                    this.pch2configs.putValue((Object)pch, (Object)oCResolveConfiguration);
                }
            }
        }

        public Collection<OCResolveConfiguration> getConfigurations(@NotNull VirtualFile pch) {
            return Collections.unmodifiableCollection(this.pch2configs.get((Object)pch));
        }

        public boolean isPCH(@NotNull VirtualFile file2) {
            return this.pch2configs.containsKey((Object)file2);
        }
    }
}

