/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCInitialInclusionContext;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveLanguageAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInclusionContextUtil {
    private static final Key<OCResolveConfiguration> PROJECT_USER_SELECTED_CONFIGURATION = Key.create((String)"PROJECT_USER_SELECTED_CONFIGURATION");
    private static final NotNullLazyKey<CachedValue<OCResolveConfiguration>, PsiFile> FILE_ACTIVE_CONFIGURATION_CACHE = NotNullLazyKey.create((String)"FILE_ACTIVE_CONFIGURATION_CACHE", file2 -> {
        final Project project2 = file2.getProject();
        return CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)new CachedValueProvider<OCResolveConfiguration>(){

            public CachedValueProvider.Result<OCResolveConfiguration> compute() {
                if (project2.isDefault()) {
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                OCWorkspaceModificationTrackers tracker = OCWorkspaceModificationTrackers.getInstance(project2);
                return new CachedValueProvider.Result((Object)this.inferConfiguration(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker(), tracker.getProjectsListTracker(), tracker.getProjectFilesListTracker(), tracker.getSourceFilesListTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }

            private OCResolveConfiguration inferConfiguration() {
                VirtualFile virtualFile;
                if (SymbolTableProvider.isSourceFile(file2) && (virtualFile = OCInclusionContextUtil.getVirtualFile(file2.getOriginalFile())) != null) {
                    return OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, file2.getProject()).getConfiguration();
                }
                return null;
            }
        }, false);
    });
    public static final NotNullLazyKey<Map<VirtualFile, OCResolveRootAndConfiguration>, Project> HEADER_ROOT_AND_CONFIGURATION_KEY = NotNullLazyKey.create((String)"HEADER_ROOT_AND_CONFIGURATION_KEY", p -> new ConcurrentHashMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCImmutableInclusionContext>, Project> HEADER_CONTEXT_KEY = NotNullLazyKey.create((String)"HEADER_CONTEXT_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());

    @Deprecated
    @Nullable
    public static OCResolveConfiguration computePreselectedConfiguration(@NotNull Project project2, @NotNull Collection<? extends OCResolveConfiguration> configs) {
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, configs).first;
    }

    @NotNull
    private static Pair<OCResolveConfiguration, Boolean> findPreselectedOrSuitableConfiguration(@NotNull Project project2, @NotNull Collection<? extends OCResolveConfiguration> configs) {
        OCResolveConfiguration selectedConfiguration = OCInclusionContextUtil.getUserSelectedConfiguration(project2);
        if (configs.contains(selectedConfiguration)) {
            return Pair.create((Object)selectedConfiguration, (Object)true);
        }
        selectedConfiguration = OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration(project2);
        if (configs.contains(selectedConfiguration)) {
            return Pair.create((Object)selectedConfiguration, (Object)true);
        }
        return Pair.create((Object)(configs.isEmpty() ? null : Collections.min(configs)), (Object)false);
    }

    @Nullable
    @Contract(value="null -> null")
    public static VirtualFile getVirtualFile(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getOriginalFile().getVirtualFile();
        return vFile != null ? vFile : (VirtualFile)file2.getUserData(IndexingDataKeys.VIRTUAL_FILE);
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file2) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (virtualFile == null) {
            return false;
        }
        return OCInclusionContextUtil.isNeedToFindRoot(virtualFile, file2.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file2, @NotNull Project project2) {
        return !OCFileImpl.isSourceCodeFile(file2.getName()) && !OCInclusionContext.isPrecompiledHeader(file2, project2);
    }

    @NotNull
    public static OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Map cache2 = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        OCResolveRootAndConfiguration cached = (OCResolveRootAndConfiguration)cache2.get(virtualFile);
        if (cached != null) {
            return cached;
        }
        OCResolveRootAndConfiguration result2 = null;
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2)) {
            result2 = OCInclusionContextUtil.getResolveRootAndActiveConfigurationForHeader(virtualFile, project2);
        }
        if (result2 == null) {
            result2 = new OCResolveRootAndConfiguration(OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, project2), virtualFile);
        }
        cache2.put(virtualFile, result2);
        ((OCInclusionContextListener)project2.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result2);
        return result2;
    }

    @NotNull
    public static OCResolveLanguageAndConfiguration getOrCalculateParsedResolveLanguageAndConfiguration(@NotNull PsiFile file2) {
        OCResolveLanguageAndConfiguration langAndConfig;
        OCResolveLanguageAndConfiguration oCResolveLanguageAndConfiguration = langAndConfig = file2 instanceof OCConfigurationOwner ? ((OCConfigurationOwner)file2).getParsedResolveLanguageAndConfiguration() : null;
        if (langAndConfig != null) {
            return langAndConfig;
        }
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file2);
        return new OCResolveLanguageAndConfiguration(context.getConfiguration(), context.getLanguageKind());
    }

    @Nullable
    private static OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile, @NotNull Project project2) {
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(OCImportGraph.getAllHeaderRoots(project2, virtualHeaderFile));
        Collections.sort(roots, new VirtualFileComparator(project2, headerNameWithoutExtension));
        OCResolveRootAndConfiguration fallBack = null;
        for (VirtualFile rootFile : roots) {
            HashSet configurations = new HashSet();
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, virtualHeaderFile, rootFile, (Set<OCResolveConfiguration>)configurations, null);
            if (configurations.isEmpty()) continue;
            Pair<OCResolveConfiguration, Boolean> found = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, (Collection<? extends OCResolveConfiguration>)configurations);
            if (((Boolean)found.second).booleanValue()) {
                return new OCResolveRootAndConfiguration((OCResolveConfiguration)found.first, rootFile);
            }
            if (fallBack != null || found.first == null) continue;
            fallBack = new OCResolveRootAndConfiguration((OCResolveConfiguration)found.first, rootFile);
        }
        return fallBack;
    }

    @Nullable
    private static OCResolveConfiguration doGetPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, OCInclusionContextUtil.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project2)).first;
    }

    public static void invalidateHeaderRootAndActiveConfigurationForAllExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, project2);
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateContextChangeCacheExcept(virtualFile, project2);
    }

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2), virtualFile);
    }

    public static <K, V> void removeExcept(@NotNull Map<K, V> map2, @Nullable K key2) {
        if (key2 == null) {
            map2.clear();
        } else {
            map2.keySet().retainAll(Collections.singleton(key2));
        }
    }

    public static void invalidateHeaderRootAndActiveConfigurationFor(@Nullable VirtualFile virtualFileInEditor, @NotNull Project project2) {
        if (virtualFileInEditor == null) {
            return;
        }
        Map cached = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        cached.remove(virtualFileInEditor);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(null, project2);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file2) {
        OCImmutableInclusionContext cached;
        PsiFile original = OCInclusionContextUtil.getOriginalFile(file2);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(null, file2);
        }
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        Map cache2 = null;
        if (virtualFile != null && (cached = (OCImmutableInclusionContext)(cache2 = (Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2)).get(virtualFile)) != null) {
            return cached;
        }
        OCInclusionContext result2 = OCInclusionContextUtil.innerCalculateHeaderContext(original, null);
        if (virtualFile != null) {
            cache2.put(virtualFile, result2);
        }
        return result2;
    }

    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file2, @Nullable OCLanguageKind languageKind) {
        PsiFile original = OCInclusionContextUtil.getOriginalFile(file2);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file2);
        }
        return OCInclusionContextUtil.innerCalculateHeaderContext(original, languageKind);
    }

    @Nullable
    private static PsiFile getOriginalFile(@Nullable PsiFile file2) {
        PsiFile psiFile;
        PsiFile physical;
        if (file2 == null) {
            return null;
        }
        PsiFile original = file2.getOriginalFile();
        if (!(original instanceof OCFile)) {
            return null;
        }
        if (original.isPhysical()) {
            return file2;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        PsiFile psiFile2 = psiFile = physical != null ? physical.getContainingFile() : null;
        if (psiFile != null) {
            return psiFile;
        }
        return null;
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind2) {
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        if (virtualFile != null && OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2)) {
            OCResolveConfiguration config;
            OCFile importHolder;
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCFile oCFile = importHolder = rootFile != null && rootFile.isValid() ? (OCFile)PsiManager.getInstance((Project)project2).findFile(rootFile) : null;
            if (importHolder != null && !rootFile.equals(virtualFile) && (config = rootAndConfiguration.getConfiguration()) != null) {
                OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
                if (precompiledContext == null) {
                    precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolder.getKind(), importHolder);
                } else {
                    precompiledContext = precompiledContext.getParent();
                    assert (precompiledContext instanceof OCInitialInclusionContext);
                }
                OCInclusionContext result2 = precompiledContext.derive(importHolder);
                result2.preprocessContextOf(importHolder, virtualFile);
                return result2;
            }
        }
        return OCInclusionContextUtil.sourceFileContext((OCFile)original, kind2);
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull OCFile file2, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        VirtualFile virtualFile;
        if (kindOrNullForDefault == null) {
            kindOrNullForDefault = file2.getKind();
        }
        if ((virtualFile = OCInclusionContextUtil.getVirtualFile(file2)) != null && (config = OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, file2.getProject())) != null) {
            return OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file2);
        }
        return OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file2);
    }

    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        Project project2 = psiFile.getProject();
        project2.putUserData(PROJECT_USER_SELECTED_CONFIGURATION, (Object)config);
        psiFile.putCopyableUserData(FILE_ACTIVE_CONFIGURATION_CACHE, null);
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor(OCInclusionContextUtil.getVirtualFile(psiFile), project2);
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            FileContentUtil.reparseFiles((Project)project2, Collections.singletonList(file2), (boolean)false);
        }
    }

    @Nullable
    private static OCResolveConfiguration getUserSelectedConfiguration(@NotNull Project project2) {
        return (OCResolveConfiguration)project2.getUserData(PROJECT_USER_SELECTED_CONFIGURATION);
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable PsiElement element) {
        return element == null ? null : (OCResolveConfiguration)((CachedValue)FILE_ACTIVE_CONFIGURATION_CACHE.getValue((UserDataHolder)element.getContainingFile())).getValue();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable VirtualFile file2, @NotNull Project project2) {
        return OCInclusionContextUtil.getActiveConfiguration(file2 == null ? null : PsiManager.getInstance((Project)project2).findFile(file2));
    }

    @NotNull
    public static Collection<? extends OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file2, @Nullable ProgressIndicator progress) {
        VirtualFile root = OCInclusionContextUtil.getVirtualFile(file2);
        if (root != null && file2 instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file2)) {
            return OCImportGraph.getAllHeaderConfigurations((OCFile)file2, progress);
        }
        return OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, file2.getProject());
    }

    @NotNull
    public static Collection<? extends OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> configOfPch = OCInclusionContext.getBuildConfigurationByPchFile(virtualFile, project2);
        if (!configOfPch.isEmpty()) {
            return configOfPch;
        }
        return OCWorkspaceManager.getWorkspace(project2).getConfigurationsForFile(virtualFile);
    }

    @NotNull
    public static Collection<? extends OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        Collection<? extends OCResolveConfiguration> result2 = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project2);
        if (!result2.isEmpty()) {
            return result2;
        }
        OCResolveConfiguration preselected = (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, OCWorkspaceManager.getWorkspace((Project)project2).getConfigurations()).first;
        return ContainerUtil.createMaybeSingletonList((Object)preselected);
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    private static String fileGuard(VirtualFile vFile, String prefix) {
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    public static void storeCachedContextChangeSet(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        ((Map)CONTEXT_CHANGES_KEY.get((UserDataHolder)project2)).put(virtualFile, changeSet);
    }

    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return (OCContextChangeSet)((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2)).get(virtualFile);
    }

    public static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        public VirtualFileComparator(Project project2, String headerNameWithoutExtension) {
            this.myProject = project2;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result2 = Comparing.compare((boolean)OCInclusionContext.isPrecompiledHeader(root1, this.myProject), (boolean)OCInclusionContext.isPrecompiledHeader(root2, this.myProject));
            if (result2 != 0) {
                return -result2;
            }
            result2 = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile(root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile(root2.getName()));
            if (result2 != 0) {
                return -result2;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result2 = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result2 != 0) {
                return -result2;
            }
            result2 = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result2 != 0) {
                return result2;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }
    }
}

