/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerProperty;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInitialInclusionContext
extends OCInclusionContextImpl {
    @NotNull
    private final CidrCompilerSwitches myCompilerSwitches;
    @NotNull
    private final Map<OCCompilerProperty.PropertyKey, Object> myPropertiesCache = new ConcurrentHashMap<OCCompilerProperty.PropertyKey, Object>();

    protected OCInitialInclusionContext(@NotNull CidrCompilerSwitches compilerSwitches, @Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCLanguageKind languageKind) {
        super(configuration, project2, languageKind);
        this.myCompilerSwitches = compilerSwitches;
    }

    public static <T> T getPropertyFromInitialContext(@NotNull OCCompilerProperty.PropertyKey key2, @NotNull OCImmutableInclusionContext fileContext) {
        OCResolveConfiguration configuration = fileContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        OCInitialInclusionContext context = OCInitialInclusionContext.getInitialContext(fileContext);
        if (context == null) {
            OCLog.LOG.warn("getPropertyFromInitialContext is called for non-initial context");
            return null;
        }
        Object value2 = context.myPropertiesCache.get((Object)key2);
        if (value2 != null) {
            return (T)value2;
        }
        if (key2.isFeature()) {
            value2 = OCCompilerKind.CLANG.equals((Object)configuration.getCompilerSettings().getCompiler(context.getLanguageKind())) ? context.isClangFeatureOrExtensionEnabled(key2.getName()) : context.getLanguageStandard().supports(OCCompilerFeatures.getFeatureStandard(key2.getName()));
        } else if (key2.isMacroSize()) {
            OCMacroSymbol macro = context.getDefinition(key2.getName());
            if (macro != null) {
                try {
                    short sizeInBits = Short.parseShort(macro.getSubstitution());
                    value2 = sizeInBits;
                }
                catch (NumberFormatException e) {
                    String message2 = "Bad size macro value:" + macro;
                    OCLog.LOG.error(message2);
                }
            }
        } else if (key2.isWarningOption()) {
            value2 = context.myCompilerSwitches.getList(CidrCompilerSwitches.Format.RAW).contains(key2.getName());
        }
        if (value2 != null) {
            context.myPropertiesCache.put(key2, value2);
        }
        return (T)value2;
    }

    @Override
    public void define(@NotNull OCMacroSymbol def) {
        super.define(def);
        this.resetPropertyCache();
    }

    @Override
    public void undef(String name) {
        super.undef(name);
        this.resetPropertyCache();
    }

    private void resetPropertyCache() {
        this.myPropertiesCache.clear();
    }

    @Nullable
    private static OCInitialInclusionContext getInitialContext(@NotNull OCImmutableInclusionContext fileContext) {
        while (!(fileContext instanceof OCInitialInclusionContext) && fileContext != null) {
            fileContext = fileContext.getParent();
        }
        return (OCInitialInclusionContext)fileContext;
    }
}

