/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParsingNameScope {
    public static final int INDEX_BEFORE_FIRST = -1;
    private static final String LOCAL_SCOPE_NAME = "$LOCAL_SCOPE$";
    public static final String GLOBAL_SCOPE_NAME = "";
    private static final int LAST_COMPONENT_INDEX = 0x3FFFFFFF;
    @NotNull
    private final String myName;
    @NotNull
    private final THashSet<String> myProtocolNames;
    @NotNull
    private final THashMap<String, Kind> myNameKinds;
    @NotNull
    private final THashMap<String, OCParsingNameScope> myInnerScopes;
    @NotNull
    private final TIntObjectHashMap<ArrayList<String>> myTypedefIndices = new TIntObjectHashMap();
    @Nullable
    private List<OCParsingNameScope> myNamespaceUsings;
    @Nullable
    private OCParsingNameScope myParent;
    @Nullable
    private OCParsingNameScope myDelegate;
    @NotNull
    private List<Pair<String, Integer>> myTemplateTypeParameters = new ArrayList<Pair<String, Integer>>();
    private List<Pair<String, Integer>> myTemplateValueParameters = new ArrayList<Pair<String, Integer>>();

    @Nullable
    public OCParsingNameScope getDelegate() {
        return this.myDelegate;
    }

    public OCParsingNameScope() {
        this(GLOBAL_SCOPE_NAME, null);
    }

    @NotNull
    public OCParsingNameScope copy() {
        return this.delegatingCopy();
    }

    @NotNull
    public OCParsingNameScope delegatingCopy() {
        OCParsingNameScope parent = this.getParent();
        OCParsingNameScope result2 = new OCParsingNameScope(this.getName(), parent == null ? null : parent.delegatingCopy());
        result2.myDelegate = this;
        return result2;
    }

    private String getNiceName() {
        if (this.getName() == GLOBAL_SCOPE_NAME) {
            return "::";
        }
        if (this.getName() == LOCAL_SCOPE_NAME) {
            return "<local>";
        }
        return this.getName();
    }

    private OCParsingNameScope(@NotNull String name, @Nullable OCParsingNameScope parent) {
        this.myName = name;
        this.myProtocolNames = new THashSet();
        this.myNameKinds = new THashMap();
        this.myInnerScopes = new THashMap();
        this.myParent = parent;
        if (parent != null) {
            OCParsingNameScope delegate;
            parent.myInnerScopes.put((Object)name, (Object)this);
            if (parent.myDelegate != null && (delegate = (OCParsingNameScope)parent.myDelegate.myInnerScopes.get((Object)name)) != null) {
                this.myDelegate = delegate;
            }
        }
    }

    public static Kind getTypeKind(boolean isTemplate) {
        return isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
    }

    public static boolean isTemplate(@Nullable Kind kind2) {
        return kind2 == Kind.TEMPLATE_TYPE || kind2 == Kind.TEMPLATE_VALUE || kind2 == Kind.UNKNOWN;
    }

    public static boolean isType(@Nullable Kind kind2) {
        return kind2 == Kind.SIMPLE_TYPE || kind2 == Kind.TEMPLATE_TYPE || kind2 == Kind.OBJC_INTERFACE || kind2 == Kind.TYPE_AND_VALUE || kind2 == Kind.UNKNOWN;
    }

    public static boolean isCppType(@Nullable Kind kind2) {
        return kind2 == Kind.SIMPLE_TYPE || kind2 == Kind.TEMPLATE_TYPE || kind2 == Kind.TYPE_AND_VALUE || kind2 == Kind.UNKNOWN;
    }

    public static boolean isValue(@Nullable Kind kind2) {
        return kind2 == Kind.SIMPLE_VALUE || kind2 == Kind.TEMPLATE_VALUE || kind2 == Kind.TYPE_AND_VALUE || kind2 == Kind.UNKNOWN;
    }

    @Nullable
    public OCParsingNameScope getParent() {
        return this.myParent;
    }

    public OCParsingNameScope dropAndGetParent() {
        if (this.myParent != null) {
            this.myParent.myInnerScopes.remove((Object)this.myName);
        }
        return this.myParent;
    }

    @Nullable
    public Kind getKind(String qualifiedName) {
        return this.getKind(Collections.singletonList(qualifiedName));
    }

    @Nullable
    public Kind getKind(List<String> qualifiedName) {
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 1 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            return this.getKindInGlobal(qualifiedName, context);
        }
        return this.getKindWithParents(qualifiedName, 0, context);
    }

    @Nullable
    private Kind getKindTerminal(@NotNull String qualifiedName, @Nullable ResolveContext context) {
        Kind result2 = null;
        OCParsingNameScope scope = this;
        while (result2 == null && scope != null) {
            result2 = (Kind)((Object)scope.myNameKinds.get((Object)qualifiedName));
            if (result2 == null && scope.myNamespaceUsings != null) {
                if (context == null) {
                    context = new ResolveContext();
                }
                if (context.shouldCheckAtOffset(scope, 0x3FFFFFFF)) {
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        Kind r = using.getKindTerminal(qualifiedName, context);
                        if (!OCParsingNameScope.isType(r) && !OCParsingNameScope.isValue(r)) continue;
                        result2 = r;
                        break;
                    }
                }
            }
            scope = scope.myDelegate;
        }
        return result2;
    }

    public boolean isProtocol(@Nullable String qualifiedName) {
        boolean result2 = this.myProtocolNames.contains((Object)qualifiedName);
        if (this.myDelegate != null) {
            result2 |= this.myDelegate.isProtocol(qualifiedName);
        }
        if (this.myParent != null) {
            result2 |= this.myParent.isProtocol(qualifiedName);
        }
        return result2;
    }

    @Nullable
    protected Kind getKind(List<String> qualifiedName, int offset, ResolveContext context) {
        if (qualifiedName.size() == 1) {
            for (Pair<String, Integer> pair : this.myTemplateValueParameters) {
                if (!((String)pair.first).equals(qualifiedName.get(0))) continue;
                return Kind.SIMPLE_VALUE;
            }
            for (Pair<String, Integer> pair : this.myTemplateTypeParameters) {
                if (!((String)pair.first).equals(qualifiedName.get(0))) continue;
                return Kind.SIMPLE_TYPE;
            }
        }
        Kind result2 = null;
        String namePart = qualifiedName.get(offset);
        if (qualifiedName.size() == offset + 1) {
            result2 = this.getKindTerminal(namePart, context);
        } else {
            OCParsingNameScope scope = this;
            while (result2 == null && scope != null) {
                OCParsingNameScope child = (OCParsingNameScope)scope.myInnerScopes.get((Object)namePart);
                if (child != null && (result2 = child.getKind(qualifiedName, offset + 1, context)) == null) {
                    result2 = Kind.UNKNOWN;
                }
                if (result2 == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                    boolean foundNonType = false;
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        result2 = using.getKindWithParents(qualifiedName, offset, context);
                        if (result2 == Kind.NON_TYPE) {
                            foundNonType = true;
                            continue;
                        }
                        if (result2 == null) continue;
                        break;
                    }
                    if (result2 == null && foundNonType) {
                        result2 = Kind.NON_TYPE;
                    }
                }
                scope = scope.myDelegate;
            }
        }
        return result2;
    }

    @Nullable
    private Kind getKindWithParents(List<String> qualifiedName, int offset, ResolveContext context) {
        Kind result2 = this.getKind(qualifiedName, offset, context);
        if (this.myParent != null) {
            if (result2 == null) {
                return this.myParent.getKindWithParents(qualifiedName, offset, context);
            }
            if (result2 == Kind.NON_TYPE) {
                Kind parentResult = this.myParent.getKindWithParents(qualifiedName, offset, context);
                return parentResult != null ? parentResult : Kind.NON_TYPE;
            }
        }
        return result2;
    }

    @Nullable
    private Kind getKindInGlobal(List<String> qualifiedName, ResolveContext context) {
        if (this.myParent != null) {
            return this.myParent.getKindInGlobal(qualifiedName, context);
        }
        if (qualifiedName.size() > 1) {
            return this.getKind(qualifiedName, 1, context);
        }
        return Kind.TEMPLATE_TYPE;
    }

    public void undefineFromIndex(int index) {
        TIntObjectIterator iter = this.myTypedefIndices.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int entryIndex = iter.key();
            if (entryIndex < index) continue;
            for (String name : (ArrayList)iter.value()) {
                this.myNameKinds.remove((Object)name);
            }
            iter.remove();
        }
    }

    private void registerIndex(String qualifiedName, int index) {
        ArrayList<String> names = (ArrayList<String>)this.myTypedefIndices.get(index);
        if (names == null) {
            names = new ArrayList<String>();
            this.myTypedefIndices.put(index, names);
        }
        names.add(qualifiedName);
    }

    @Nullable
    public Kind defineType(@NotNull String qualifiedName, boolean isTemplate) {
        return this.defineType(qualifiedName, isTemplate, false, -1);
    }

    @Nullable
    public Kind defineType(@NotNull String qualifiedName, boolean isTemplate, boolean isFriend, int index) {
        Kind kind2 = isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isValue(existing)) {
            kind2 = Kind.TYPE_AND_VALUE;
        } else {
            if (existing == Kind.TEMPLATE_TYPE) {
                return Kind.TEMPLATE_TYPE;
            }
            if (isFriend && this.getKind(qualifiedName) != null) {
                return this.getKind(qualifiedName);
            }
        }
        return this.registerKind(qualifiedName, index, kind2);
    }

    @Nullable
    public Kind defineInterface(String qualifiedName) {
        return this.defineInterface(qualifiedName, -1);
    }

    @Nullable
    public Kind defineInterface(String qualifiedName, int index) {
        Kind kind2 = Kind.OBJC_INTERFACE;
        if (OCParsingNameScope.isValue(this.getKindTerminal(qualifiedName, null))) {
            kind2 = Kind.TYPE_AND_VALUE;
        }
        return this.registerKind(qualifiedName, index, kind2);
    }

    public void defineProtocol(String name) {
        this.defineProtocol(name, -1);
    }

    public void defineProtocol(String name, int index) {
        this.myProtocolNames.add((Object)name);
        this.registerIndex(name, index);
    }

    public Kind defineValue(String qualifiedName, boolean isTemplate) {
        return this.defineValue(qualifiedName, isTemplate, -1);
    }

    public Kind defineValue(String qualifiedName, boolean isTemplate, int index) {
        Kind kind2 = isTemplate ? Kind.TEMPLATE_VALUE : Kind.SIMPLE_VALUE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isType(existing)) {
            kind2 = Kind.TYPE_AND_VALUE;
        } else if (existing == Kind.TEMPLATE_VALUE) {
            return Kind.TEMPLATE_VALUE;
        }
        return this.registerKind(qualifiedName, index, kind2);
    }

    private Kind registerKind(String name, int index, Kind kind2) {
        this.registerIndex(name, index);
        return (Kind)((Object)this.myNameKinds.put((Object)name, (Object)kind2));
    }

    public OCParsingNameScope defineNamespace(@NotNull String name) {
        OCParsingNameScope scope = (OCParsingNameScope)this.myInnerScopes.get((Object)name);
        if (scope == null || scope.getParent() != this) {
            scope = new OCParsingNameScope(name, this);
        }
        return scope;
    }

    public OCParsingNameScope defineLocalScope() {
        return new OCParsingNameScope(LOCAL_SCOPE_NAME, this);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "OCParsingNameScope{" + this.getNiceName() + "}";
    }

    public void defineNamespaceAlias(String alias, String namespaceName) {
        this.defineNamespaceAlias(alias, Collections.singletonList(namespaceName));
    }

    public void defineNamespaceAlias(String alias, List<String> namespaceName) {
        OCParsingNameScope scope = this.resolveNamespace(namespaceName);
        if (scope != null) {
            this.myInnerScopes.put((Object)alias, (Object)scope);
        }
    }

    public void defineNamespaceUsing(@NotNull List<String> qualifiedName) {
        OCParsingNameScope scope;
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>();
        }
        if ((scope = this.resolveNamespace(qualifiedName)) != null && scope != this && !this.myNamespaceUsings.contains(scope)) {
            this.myNamespaceUsings.add(scope);
        }
    }

    public void defineNamespaceUsing(@NotNull String name) {
        this.defineNamespaceUsing(Collections.singletonList(name));
    }

    public void defineSymbolUsing(@NotNull String name) {
        this.defineSymbolUsing(Collections.singletonList(name));
    }

    public void defineSymbolUsing(@NotNull List<String> qualifiedName) {
        Kind kind2 = this.getKind(qualifiedName);
        boolean isType = OCParsingNameScope.isType(kind2);
        if (!isType && !OCParsingNameScope.isValue(kind2)) {
            return;
        }
        String alias = qualifiedName.get(qualifiedName.size() - 1);
        this.registerKind(alias, Integer.MAX_VALUE, kind2);
        if (isType) {
            this.defineNamespaceAlias(alias, qualifiedName);
        }
    }

    @NotNull
    public List<Pair<String, Integer>> getTemplateValueParameters() {
        return this.myTemplateValueParameters;
    }

    @NotNull
    public List<Pair<String, Integer>> getTemplateTypeParameters() {
        return this.myTemplateTypeParameters;
    }

    public void addTemplateValueParameter(@NotNull String qualifiedName, int index) {
        this.myTemplateValueParameters.add((Pair<String, Integer>)Pair.create((Object)qualifiedName, (Object)index));
    }

    public void addTemplateTypeParameter(@NotNull String qualifiedName, int index) {
        this.myTemplateTypeParameters.add((Pair<String, Integer>)Pair.create((Object)qualifiedName, (Object)index));
    }

    public void clearTemplateParameters() {
        this.myTemplateValueParameters.clear();
        this.myTemplateTypeParameters.clear();
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(@NotNull List<String> qualifiedName) {
        OCParsingNameScope result2;
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 0 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            OCParsingNameScope global = this;
            while (global.myParent != null) {
                global = global.myParent;
            }
            result2 = global.resolveNamespace(qualifiedName, 1, context);
        } else {
            result2 = this.resolveNamespace(qualifiedName, 0, context);
        }
        return result2;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(List<String> qualifiedName, int offset, ResolveContext context) {
        if (offset == qualifiedName.size()) {
            return this;
        }
        OCParsingNameScope result2 = null;
        String name = qualifiedName.get(offset);
        OCParsingNameScope scope = this;
        while (result2 == null && scope != null) {
            OCParsingNameScope child = (OCParsingNameScope)scope.myInnerScopes.get((Object)name);
            if (child != null) {
                result2 = child.resolveNamespace(qualifiedName, offset + 1, context);
            }
            if (result2 == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                OCParsingNameScope using;
                Iterator<OCParsingNameScope> iterator = scope.myNamespaceUsings.iterator();
                while (iterator.hasNext() && (result2 = (using = iterator.next()).resolveNamespace(qualifiedName, offset, context)) == null) {
                }
            }
            scope = scope.myDelegate;
        }
        if (result2 == null && this.myParent != null) {
            result2 = this.myParent.resolveNamespace(qualifiedName, offset, context);
        }
        return result2;
    }

    public DeepEqual.Equality<OCParsingNameScope> equality() {
        return new DeepEquality();
    }

    private static class DeepEquality
    implements DeepEqual.Equality<OCParsingNameScope> {
        private DeepEquality() {
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCParsingNameScope first, @NotNull OCParsingNameScope second) {
            if (!first.myName.equals(second.myName)) {
                return false;
            }
            if (!first.myNameKinds.equals((Object)second.myNameKinds)) {
                return false;
            }
            if (!first.myProtocolNames.equals((Object)second.myProtocolNames)) {
                return false;
            }
            if (!first.myTypedefIndices.equals((Object)second.myTypedefIndices)) {
                return false;
            }
            if (!c.equalIterable(first.myNamespaceUsings, second.myNamespaceUsings)) {
                return false;
            }
            if (!c.equalObjects(first.myParent, second.myParent)) {
                return false;
            }
            return c.equalMaps((Map)first.myInnerScopes, (Map)second.myInnerScopes);
        }
    }

    private static class ResolveContext {
        private THashMap<OCParsingNameScope, List<Integer>> myCurrentOffsets;

        private ResolveContext() {
        }

        public boolean shouldCheckAtOffset(@NotNull OCParsingNameScope scope, int positionInName) {
            List checkedPositions;
            if (this.myCurrentOffsets == null) {
                this.myCurrentOffsets = new THashMap();
                checkedPositions = null;
            } else {
                checkedPositions = (List)this.myCurrentOffsets.get((Object)scope);
            }
            if (checkedPositions == null) {
                checkedPositions = new SmartList((Object)positionInName);
                this.myCurrentOffsets.put((Object)scope, (Object)checkedPositions);
            } else if (!checkedPositions.contains(positionInName)) {
                checkedPositions.add(positionInName);
            } else {
                return false;
            }
            return true;
        }
    }

    public static enum Kind {
        UNKNOWN,
        SIMPLE_TYPE,
        TEMPLATE_TYPE,
        SIMPLE_VALUE,
        TEMPLATE_VALUE,
        OBJC_INTERFACE,
        TYPE_AND_VALUE,
        NON_TYPE;

    }
}

