/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompoundInitializerImpl
extends OCExpressionBase
implements OCCompoundInitializer {
    public OCCompoundInitializerImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCompoundInitializer(this);
    }

    @Override
    @NotNull
    public List<OCCompoundInitializerMember> getInitializers() {
        ArrayList<OCCompoundInitializerMember> list = new ArrayList<OCCompoundInitializerMember>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCElementTypes.EXPRESSIONS.contains(tt)) {
                list.add((OCCompoundInitializerMember)child.getPsi());
                continue;
            }
            if (tt != OCElementTypes.DESIGNATED_INITIALIZER) continue;
            list.add((OCCompoundInitializerMember)child.getPsi());
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCExpression> getInitializerExpressions() {
        return ContainerUtil.map(this.getInitializers(), member -> member instanceof OCDesignatedInitializer ? ((OCDesignatedInitializer)member).getInitializer() : (OCExpression)member);
    }

    @Override
    @Nullable
    public OCType inferType() {
        Collection<OCType> types = OCExpectedTypeUtil.getExpectedTypes(this, false);
        return (OCType)ContainerUtil.getFirstItem(types);
    }

    @Override
    @Nullable
    public OCType inferChildType(OCElement element) {
        OCType refType = this.inferType();
        if (refType == null) {
            return null;
        }
        List children2 = this.findChildrenByType(OCElementTypes.COMPOUND_INITIALIZER_EXPRESSIONS);
        OCType type2 = refType.resolve(this.getContainingFile());
        if (refType instanceof OCArrayType) {
            return new ChildTypeInference(children2, element).traverseArray((OCArrayType)type2, null);
        }
        if (type2 instanceof OCStructType) {
            return new ChildTypeInference(children2, element).traverseStruct((OCStructType)type2, new HashSet());
        }
        return null;
    }

    @Override
    public void inferChildTypes(Map<PsiElement, Pair<OCType, OCSymbol>> acc, Set<OCSymbol> initedFields) {
        Pair refType;
        if (acc.containsKey(this)) {
            refType = acc.get(this);
        } else {
            refType = new Pair((Object)this.inferType(), null);
            acc.put(this, (Pair<OCType, OCSymbol>)refType);
        }
        if (refType == null) {
            return;
        }
        List<PsiElement> children2 = this.findChildrenByType(OCElementTypes.COMPOUND_INITIALIZER_EXPRESSIONS);
        OCType type2 = ((OCType)refType.first).resolve(this.getContainingFile());
        if (type2 instanceof OCArrayType) {
            new ChildTypeInference(children2, acc).traverseArray((OCArrayType)type2, null);
        } else if (type2 instanceof OCStructType) {
            new ChildTypeInference(children2, acc).traverseStruct((OCStructType)type2, initedFields);
        }
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (!OCCompilerHelper.supportsInitializerLists(this.getContainingOCFile())) {
            return super.getType(context);
        }
        return OCCompoundInitializerImpl.getCompoundInitializerType(OCArgumentsList.getArgumentList(this.getInitializerExpressions()), context);
    }

    @NotNull
    public static OCType getCompoundInitializerType(@NotNull OCArgumentsList<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        OCType type2 = null;
        for (OCType exprType : arguments.getTypes()) {
            type2 = type2 == null ? exprType : type2.getLeastCommonType(exprType, context.getElement());
        }
        List<OCTypeArgument> typeArguments = type2 != null ? Collections.singletonList(type2) : Collections.emptyList();
        return OCReferenceType.fromLocalText(new OCQualifiedNameWithArguments(OCQualifiedName.parse("std::initializer_list"), typeArguments));
    }

    private static class ChildTypeInference {
        private final PsiElement myTarget;
        private final List<PsiElement> myChildren;
        private final Map<PsiElement, Pair<OCType, OCSymbol>> myAcc;
        private final PsiFile myFile;
        private final int myChildrenSize;
        int myChildCounter;

        private ChildTypeInference(List<PsiElement> children2, PsiElement target) {
            this.myChildren = children2;
            this.myChildrenSize = this.myChildren.size();
            this.myChildCounter = 0;
            this.myTarget = target;
            this.myAcc = null;
            this.myFile = this.myTarget.getContainingFile();
        }

        public ChildTypeInference(List<PsiElement> children2, Map<PsiElement, Pair<OCType, OCSymbol>> acc) {
            this.myChildren = children2;
            this.myChildrenSize = this.myChildren.size();
            this.myChildCounter = 0;
            this.myTarget = null;
            this.myAcc = acc;
            this.myFile = !this.myChildren.isEmpty() ? this.myChildren.get(0).getContainingFile() : null;
        }

        @Nullable
        private OCType traverseStruct(OCStructType struct, Set<OCSymbol> initedFields) {
            List<OCDeclaratorSymbol> fields = struct.getFields();
            int fieldsSize = fields.size();
            int fieldCounter = 0;
            while (fieldCounter < fieldsSize && this.myChildCounter < this.myChildrenSize) {
                OCType result2;
                OCExpression expression2;
                OCDeclaratorSymbol field = fields.get(fieldCounter);
                PsiElement child = this.myChildren.get(this.myChildCounter);
                if (field.getKind() != OCSymbolKind.STRUCT_FIELD || initedFields.contains(field) || field.isUnnamed() && !(child instanceof OCCompoundInitializer)) {
                    ++fieldCounter;
                    continue;
                }
                if (child instanceof OCDesignatedInitializer) {
                    if (this.myAcc != null) {
                        this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)field.getType(), (Object)field));
                    }
                    if (child == this.myTarget) {
                        return field.getType();
                    }
                    OCDesignatedInitializer initializer = (OCDesignatedInitializer)child;
                    OCSymbol symbol = initializer.getDesignation().resolveToSymbol();
                    initedFields.add(symbol);
                    ++this.myChildCounter;
                    continue;
                }
                if (child instanceof OCCompoundInitializer) {
                    if (this.myAcc != null) {
                        this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)field.getType(), (Object)field));
                        ((OCCompoundInitializer)child).inferChildTypes(this.myAcc, (Set<OCSymbol>)(field.isUnnamed() ? initedFields : new HashSet<OCSymbol>()));
                    }
                    if (child == this.myTarget) {
                        return field.getType();
                    }
                    initedFields.add(field);
                    ++fieldCounter;
                    ++this.myChildCounter;
                    continue;
                }
                boolean sameType = false;
                OCType fieldType = field.getType().resolve(child.getContainingFile());
                if (child instanceof OCExpression && fieldType.isCompatible((expression2 = (OCExpression)child).getResolvedType(), expression2.getContainingOCFile())) {
                    sameType = true;
                }
                if (!sameType && fieldType instanceof OCStructType && ((OCStructType)fieldType).getKind() == OCSymbolKind.STRUCT) {
                    result2 = this.traverseStruct((OCStructType)fieldType, new HashSet<OCSymbol>());
                    if (result2 != null) {
                        return result2;
                    }
                    initedFields.add(field);
                    ++fieldCounter;
                    continue;
                }
                if (!sameType && fieldType instanceof OCArrayType) {
                    result2 = this.traverseArray((OCArrayType)fieldType, field);
                    if (result2 != null) {
                        return result2;
                    }
                    initedFields.add(field);
                    ++fieldCounter;
                    continue;
                }
                if (this.myAcc != null) {
                    this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)field.getType(), (Object)field));
                }
                if (child == this.myTarget) {
                    return field.getType();
                }
                initedFields.add(field);
                ++fieldCounter;
                ++this.myChildCounter;
            }
            return null;
        }

        @Nullable
        private OCType traverseArray(OCArrayType array, @Nullable OCSymbol symbol) {
            OCType elementType = array.getRefType();
            if (!this.myChildren.isEmpty()) {
                elementType = elementType.resolve(this.myChildren.get(0).getContainingFile());
            }
            int elementCounter = 0;
            boolean emptyArray = elementType instanceof OCStructType && ((OCStructType)elementType).isEmpty(new HashSet<OCStructSymbol>()) || elementType instanceof OCArrayType && ((OCArrayType)elementType).isEmpty(this.myFile, new HashSet<OCStructSymbol>());
            int length = array.getLength();
            while (!(array.hasLength() && elementCounter >= length || this.myChildCounter >= this.myChildrenSize)) {
                OCSymbol curSymbol;
                OCType type2;
                OCType result2;
                OCType type3;
                PsiElement child = this.myChildren.get(this.myChildCounter);
                boolean sameType = false;
                if (child instanceof OCDesignatedInitializer || child instanceof OCCompoundInitializer) {
                    sameType = true;
                } else if (child instanceof OCExpression && elementType.isCompatible(type3 = ((OCExpression)child).getResolvedType(), child)) {
                    sameType = true;
                }
                if (sameType) {
                    if (this.myAcc != null) {
                        this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)array.getRefType(), null));
                    }
                    if (child == this.myTarget) {
                        if (child instanceof OCExpression && emptyArray) break;
                        return array.getRefType();
                    }
                    ++this.myChildCounter;
                    ++elementCounter;
                    continue;
                }
                if (elementType instanceof OCStructType && ((OCStructType)elementType).getKind() == OCSymbolKind.STRUCT) {
                    if (emptyArray) break;
                    result2 = this.traverseStruct((OCStructType)elementType, new HashSet<OCSymbol>());
                    if (result2 != null) {
                        return result2;
                    }
                    ++elementCounter;
                    continue;
                }
                if (elementType instanceof OCArrayType) {
                    if (emptyArray) break;
                    result2 = this.traverseArray((OCArrayType)elementType, null);
                    if (result2 != null) {
                        return result2;
                    }
                    ++elementCounter;
                    continue;
                }
                boolean isCharArray = false;
                OCExpression innerChild = null;
                if (child instanceof OCExpression) {
                    innerChild = OCParenthesesUtils.diveIntoParentheses((OCExpression)child);
                }
                if (innerChild instanceof OCLiteralExpression && array.isCString() && (type2 = ((OCExpression)child).getResolvedType()).isCString()) {
                    isCharArray = true;
                }
                type2 = isCharArray ? array : array.getRefType();
                OCSymbol oCSymbol = curSymbol = isCharArray ? symbol : null;
                if (this.myAcc != null) {
                    this.myAcc.put(child, (Pair<OCType, OCSymbol>)Pair.create((Object)type2, (Object)curSymbol));
                }
                if (child == this.myTarget) {
                    return type2;
                }
                ++this.myChildCounter;
                if (isCharArray) break;
                ++elementCounter;
            }
            return null;
        }
    }
}

