/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionImpl
extends OCExpressionBase
implements OCConditionalExpression {
    public OCConditionalExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCExpression getCondition() {
        OCExpression cond = this.findExpression(0);
        assert (cond != null);
        return cond;
    }

    @Override
    public OCExpression getPositiveExpression(boolean returnConditionIfNull) {
        OCExpression expression2 = this.findExpression(1);
        return expression2 != null || !returnConditionIfNull ? expression2 : this.getCondition();
    }

    @Override
    public OCExpression getNegativeExpression() {
        return this.findExpression(2);
    }

    @Nullable
    private OCExpression findExpression(int n) {
        int count = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCElementTypes.EXPRESSIONS.contains(tt) && count == n) {
                return (OCExpression)child.getPsi();
            }
            if (count == 0 && tt == OCTokenTypes.QUEST) {
                count = 1;
                continue;
            }
            if (count != 1 || tt != OCTokenTypes.COLON) continue;
            count = 2;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCExpression leftExpr = this.getPositiveExpression(true);
        OCExpression rightExpr = this.getNegativeExpression();
        if (leftExpr != null && rightExpr != null) {
            OCType lType = leftExpr.getResolvedType(context);
            OCType rType = rightExpr.getResolvedType(context);
            return OCConditionalExpressionImpl.getConditionalExprType(lType, rType, OCExpressionEvaluator.isLikeNil(leftExpr, context), OCExpressionEvaluator.isLikeNil(rightExpr, context), this);
        }
        return OCUnknownType.INSTANCE;
    }

    public static OCType getConditionalExprType(OCType lType, OCType rType, boolean leftIsNil, boolean rightIsNil, @Nullable PsiElement context) {
        OCType commonType;
        boolean referencesBoth;
        boolean bl = referencesBoth = lType instanceof OCCppReferenceType && rType instanceof OCCppReferenceType;
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType();
        }
        if (rType instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        if (rightIsNil) {
            if (lType instanceof OCBlockPointerType) {
                rType = OCBlockPointerType.blockPtr(((OCBlockPointerType)lType).getRefType());
            } else if (lType instanceof OCPointerType) {
                OCPointerType lPtrType = (OCPointerType)lType;
                rType = OCPointerType.to(lPtrType.getRefType(), lPtrType.getARCAttribute(), lPtrType.getClassQualifier());
            }
        }
        if (leftIsNil) {
            if (rType instanceof OCBlockPointerType) {
                lType = OCBlockPointerType.blockPtr(((OCBlockPointerType)rType).getRefType());
            } else if (rType instanceof OCPointerType) {
                OCPointerType rPtrType = (OCPointerType)rType;
                lType = OCPointerType.to(rPtrType.getRefType(), rPtrType.getARCAttribute(), rPtrType.getClassQualifier());
            }
        }
        if ((commonType = lType.getLeastCommonType(rType, context)) instanceof OCUnknownType) {
            if (lType.isCompatible(rType, context)) {
                commonType = lType;
            } else if (rType.isCompatible(lType, context)) {
                commonType = rType;
            }
        }
        return referencesBoth ? OCCppReferenceType.to(commonType) : commonType;
    }
}

