/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNewExpressionImpl
extends OCExpressionBase
implements OCCppNewExpression {
    public OCCppNewExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCTypeElement type2 = this.findChildByClass(OCTypeElement.class);
        return type2 != null ? OCCppNewExpressionImpl.getNewExprType(type2.getType(), type2.getArrayLengths()) : super.getType(context);
    }

    @NotNull
    public static OCType getNewExprType(@NotNull OCType type2, int arrayLengths) {
        for (int i2 = 0; i2 < arrayLengths && type2 instanceof OCPointerType; ++i2) {
            type2 = ((OCPointerType)type2).getRefType();
        }
        return OCPointerType.to(type2);
    }

    @Override
    @Nullable
    public OCTypeElement getConstructingTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCReferenceElement getReferenceElement() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        ASTNode node = typeElement != null ? typeElement.getNode().findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT) : null;
        return node != null ? (OCReferenceElement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public OCType getConstructingType() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        return typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public OCArgumentList getArgumentList() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        for (PsiElement child = this.getLastChild(); child != null && child != typeElement; child = child.getPrevSibling()) {
            if (!(child instanceof OCArgumentList)) continue;
            return (OCArgumentList)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        OCArgumentList argumentList = this.getArgumentList();
        return argumentList != null ? argumentList.getArguments() : Collections.emptyList();
    }

    public OCCompoundInitializer getInitializerList() {
        OCCompoundInitializer initializer = (OCCompoundInitializer)this.findChildByType(OCElementTypes.COMPOUND_INITIALIZER);
        if (initializer != null) {
            return initializer;
        }
        OCTypeElement typeElement = this.getConstructingTypeElement();
        if (typeElement != null) {
            for (PsiElement child = typeElement.getLastChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof OCCompoundInitializer)) continue;
                return (OCCompoundInitializer)child;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<OCExpression> getInitializers() {
        OCArgumentList argumentList = this.getArgumentList();
        if (argumentList != null) {
            return argumentList.getArguments();
        }
        OCCompoundInitializer initializerList = this.getInitializerList();
        return initializerList != null ? Collections.singletonList(initializerList) : Collections.emptyList();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCppNewExpression(this);
    }
}

