/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclarationImpl
extends OCElementBase
implements OCDeclaration {
    public OCDeclarationImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @NotNull
    public OCType getType() {
        OCTypeElement typeElement = this.getTypeElement();
        return typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    public final OCType getResolvedType() {
        return this.getType().resolve(this.getContainingFile());
    }

    @Override
    @NotNull
    public List<OCDeclarator> getDeclarators() {
        return this.findChildrenByType(OCElementTypes.DECLARATOR);
    }

    @Override
    public boolean isTypedef() {
        OCTypeElement typeElement = this.getTypeElement();
        return typeElement != null && typeElement.getNode().findChildByType((IElementType)OCTokenTypes.TYPEDEF_KEYWORD) != null;
    }

    @Override
    @Nullable
    public OCTemplateParameterList getTemplateParameterList() {
        return (OCTemplateParameterList)this.findChildByType(OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitDeclaration(this);
    }

    @Override
    public boolean isStatic() {
        return this.findChildByType(OCTokenTypes.STATIC_KEYWORD) != null;
    }

    @Override
    @Nullable
    public OCTypeArgumentList getTemplateArgumentList() {
        List<OCDeclarator> declarators = this.getDeclarators();
        if (declarators.size() == 1) {
            return declarators.get(0).getTemplateArgumentList();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        List<OCDeclarator> declarators = this.getDeclarators();
        if (declarators.size() == 1) {
            return OCResolveUtil.resolveTemplateDeclarations(declarators.get(0));
        }
        return Collections.emptyList();
    }
}

