/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclaratorImpl
extends OCElementWithReferenceBase
implements OCDeclarator {
    private static final MyResolver resolver = new MyResolver();

    public OCDeclaratorImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCType getType() {
        if (this.getParent().getParent() instanceof OCEnum) {
            return OCIntType.INT;
        }
        OCSymbol symbol = this.getLocalSymbol();
        return symbol != null ? symbol.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    public OCType getResolvedType() {
        return this.getType().resolve(this.getContainingFile());
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.getType().resolve(context);
    }

    @Override
    public OCSymbol getSymbol() {
        if (!this.isValid()) {
            return null;
        }
        OCSymbol symbol = this.getContainingOCFile().findSymbol(this, OCSymbol.class);
        return symbol != null ? symbol : this.getLocalSymbol();
    }

    @Nullable
    public OCSymbol getLocalSymbol() {
        OCElement context;
        OCFile file2 = this.getContainingOCFile();
        final String name = this.getSymbolName();
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol.getOffset() == OCDeclaratorImpl.this.getTextOffset() && Comparing.equal((String)name, (String)symbol.getName());
            }
        };
        ASTNode declarationNode = this.getNode().getTreeParent();
        OCLanguageKind kind2 = file2.getKind();
        PsiElement fileContext = file2.getContext();
        if (fileContext != null) {
            file2 = (OCFile)fileContext.getContainingFile();
        }
        OCBuilderDriver<ASTNode> builderDriver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(kind2, file2), new ASTStructure(declarationNode), BuilderDriverBase.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)finder);
        builderDriver.processDeclaration(declarationNode, (Processor<OCSymbol>)finder, this.getDeclarationContext());
        OCSymbol result2 = (OCSymbol)finder.getFoundValue();
        if (result2 instanceof OCDeclaratorSymbol && (context = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCLocalScopeable.class, OCEnum.class})) instanceof OCEnum) {
            OCStructSymbol enumSymbol = (OCStructSymbol)((OCEnum)context).getSymbol();
            if (enumSymbol != null && enumSymbol.getKind() == OCSymbolKind.ENUM) {
                ((OCDeclaratorSymbol)result2).setType(enumSymbol.getType());
            } else {
                ((OCDeclaratorSymbol)result2).setType(OCIntType.INT);
            }
        }
        return result2;
    }

    @Nullable
    protected PsiReference createReference() {
        return new MyReference();
    }

    @NotNull
    private BuilderDriverBase.DeclarationContext getDeclarationContext() {
        OCDeclaratorImpl element = this.getParent() instanceof OCFunctionDefinition ? this.getParent() : this;
        Pair<List<PsiElement>, OCSymbolKind> pair = OCCodeInsightUtil.getScopeAndKind(element);
        PsiElement scope = (PsiElement)ContainerUtil.getFirstItem((List)((List)pair.getFirst()));
        OCSymbolKind kind2 = (OCSymbolKind)((Object)pair.getSecond());
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this.getParent());
        BuilderDriverBase.DeclarationContext context = new BuilderDriverBase.DeclarationContext(kind2, scope, parent, null, scope != null ? this : null, false);
        context.setTemplateValueParameter(this.getParent().getParent() instanceof OCTemplateParameterList);
        PsiElement grParent = this.getParent().getParent().getParent();
        if (grParent instanceof OCForeachStatement) {
            OCExpression collectionExpr = ((OCForeachStatement)grParent).getCollectionExpression();
            context.setForCollection(collectionExpr != null ? collectionExpr.getNode() : null);
        }
        if (this.getParent() instanceof OCParameterDeclaration && grParent instanceof OCLambdaExpression) {
            context.setLambdaParameterIndex(((OCParameterList)this.getParent().getParent()).getParameterDeclarations().indexOf(this.getParent()));
        }
        if (this.getParent().getParent() instanceof OCLambdaIntroducer) {
            context.setLambdaInitCapture(true);
        }
        return context;
    }

    @Override
    @NotNull
    public OCType getRawType() {
        return this.getType();
    }

    @Override
    @NotNull
    public List<OCExpression> getArrayLengths() {
        ArrayList<OCExpression> list = new ArrayList<OCExpression>();
        OCExpression lastExpression = null;
        boolean operator2 = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                operator2 = true;
            }
            if (tt == OCTokenTypes.LBRACKET) {
                lastExpression = null;
                continue;
            }
            if (OCElementTypes.EXPRESSIONS.contains(tt)) {
                lastExpression = (OCExpression)child.getPsi();
                continue;
            }
            if (tt == OCTokenTypes.RBRACKET) {
                if (!operator2 || lastExpression != null) {
                    list.add(lastExpression);
                }
                operator2 = false;
                continue;
            }
            if (tt == OCTokenTypes.EQ) break;
        }
        return list;
    }

    @Override
    public OCExpression getInitializer() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.EQ) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public OCArgumentList getArgumentList() {
        return (OCArgumentList)this.findChildByType(OCElementTypes.ARGUMENT_LIST);
    }

    @Override
    public OCCompoundInitializer getInitializerList() {
        return (OCCompoundInitializer)this.findChildByType(OCElementTypes.COMPOUND_INITIALIZER);
    }

    @Override
    public boolean isExplicitConstructorCall() {
        return this.getArgumentList() != null || this.getInitializerList() != null;
    }

    @Override
    @NotNull
    public List<OCExpression> getInitializers() {
        OCArgumentList argumentList = this.getArgumentList();
        if (argumentList != null) {
            return argumentList.getArguments();
        }
        OCCompoundInitializer initializerList = this.getInitializerList();
        if (initializerList != null) {
            return Collections.singletonList(initializerList);
        }
        OCExpression initializer = this.getInitializer();
        return initializer != null ? Collections.singletonList(initializer) : Collections.emptyList();
    }

    @Override
    public OCParameterList getParameterList() {
        return (OCParameterList)this.findChildByType(OCElementTypes.PARAMETER_LIST);
    }

    @Override
    public boolean isPointerToFunction() {
        Object lpar = this.findChildByType(OCTokenTypes.LPAR);
        Object ptrLikeModifier = this.findChildByType(OCTokenTypes.FUNCTION_PTR_MODIFIERS);
        PsiElement name = this.getNameIdentifier();
        if (lpar != null && ptrLikeModifier != null && name != null) {
            int lparOffset = OCElementUtil.getRangeWithMacros(lpar).getStartOffset();
            int ptrOffset = OCElementUtil.getRangeWithMacros(ptrLikeModifier).getStartOffset();
            int nameOffset = OCElementUtil.getRangeWithMacros(name).getStartOffset();
            return lparOffset <= ptrOffset && ptrOffset <= nameOffset;
        }
        return false;
    }

    @Override
    public boolean isPossibleStructMember() {
        if (this.getNamespaceQualifier() != null) {
            return true;
        }
        PsiElement context = PsiTreeUtil.getContextOfType((PsiElement)this.getExtendedContext(), (boolean)true, (Class[])new Class[]{OCStructLike.class, OCFunctionDefinition.class});
        return context instanceof OCStructLike;
    }

    @Override
    @NotNull
    public PsiElement getExtendedContext() {
        PsiElement parent = this.getParent();
        return parent instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)parent).getDeclarator() == this ? parent : this;
    }

    @Override
    @NotNull
    public String getName() {
        return OCElementUtil.getIdentifierName(this.getNameIdentifier());
    }

    @Override
    @NotNull
    public String getSymbolName() {
        return OCElementUtil.getIdentifierName(this.findReferenceTokenInCall());
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findNameStartTokenInCall();
    }

    @Override
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType(OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    @Override
    @NotNull
    public String getModifiersText() {
        IElementType type2;
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null && (OCTokenTypes.DECLARATOR_MODIFIERS.contains(type2 = child.getElementType()) || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type2)); child = child.getTreeNext()) {
            builder.append(child.getText());
        }
        return builder.toString().trim();
    }

    @Override
    public int getTextOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    @Override
    public long getComplexOffset() {
        PsiElement ident = this.getNameIdentifier();
        return ident == null ? super.getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(ident);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    @Nullable
    public <T extends PsiElement> T findChildByType(IElementType type2) {
        return super.findChildByType(type2);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitDeclarator(this);
    }

    @Override
    @Nullable
    public OCTemplateArgumentList getTemplateArgumentList() {
        return (OCTemplateArgumentList)this.findChildByType(OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    private static class MyResolver
    implements ResolveCache.AbstractResolver<MyReference, OCSymbol> {
        private MyResolver() {
        }

        @Override
        public OCSymbol resolve(@NotNull MyReference reference, boolean incompleteCode) {
            return reference.doResolveToSymbol();
        }
    }

    private class MyReference
    implements OCReference {
        private MyReference() {
        }

        public PsiElement getElement() {
            return OCDeclaratorImpl.this;
        }

        public TextRange getRangeInElement() {
            PsiElement ident = OCDeclaratorImpl.this.getNameIdentifier();
            return ident != null ? TextRange.from((int)ident.getStartOffsetInParent(), (int)ident.getTextLength()) : TextRange.EMPTY_RANGE;
        }

        public PsiElement resolve() {
            OCSymbol symbol = this.resolveToSymbol();
            return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
        }

        @NotNull
        public String getCanonicalText() {
            return OCDeclaratorImpl.this.getName();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return OCDeclaratorImpl.this;
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            assert (symbol.getKind() == OCSymbolKind.STRUCT || symbol.getKind().isConstructorOrDestructor());
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCFunctionDeclaration)) {
                return false;
            }
            OCSymbol symbol = ((OCFunctionDeclaration)element).getSymbol();
            OCSymbol thisSymbol = this.resolveToSymbol();
            if (Comparing.equal((Object)thisSymbol, (Object)symbol)) {
                return true;
            }
            if (thisSymbol instanceof OCSymbolWithQualifiedName && symbol != null && thisSymbol.isGlobal() && symbol.isGlobal()) {
                OCQualifiedName symbolName;
                OCQualifiedName thisName = ((OCSymbolWithQualifiedName)thisSymbol).getResolvedQualifiedName();
                if (Comparing.equal((Object)thisName, (Object)(symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName()))) {
                    OCType symbolType;
                    OCType thisResolvedType = thisSymbol.getResolvedType();
                    return thisResolvedType.equals((Object)(symbolType = symbol.getResolvedType()), element);
                }
                return false;
            }
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        @Override
        public OCSymbol resolveToSymbol() {
            return ResolveCache.getInstance(OCDeclaratorImpl.this.getProject()).resolveWithCaching(this, resolver, false, false);
        }

        public OCSymbol doResolveToSymbol() {
            OCType ownType = OCDeclaratorImpl.this.getResolvedType();
            if (ownType instanceof OCCppReferenceType) {
                ownType = ((OCCppReferenceType)ownType).getRefType();
            }
            if (!(ownType instanceof OCStructType)) {
                return null;
            }
            PsiElement parent = OCDeclaratorImpl.this.getParent();
            if (!(parent instanceof OCDeclaration) || ((OCDeclaration)parent).isTypedef()) {
                return null;
            }
            if (parent.getParent() instanceof OCStruct) {
                return null;
            }
            OCResolveContext context = new OCResolveContext(OCDeclaratorImpl.this);
            return ((OCStructType)ownType).findConstructor(OCArgumentsList.getArgumentList(OCDeclaratorImpl.this.getInitializers()), context, OCDeclaratorImpl.this.isExplicitConstructorCall(), false, null);
        }
    }
}

