/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCDeclarationImpl;
import com.jetbrains.cidr.lang.psi.impl.OCDeclaratorImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionDeclarationImpl
extends OCDeclarationImpl
implements OCFunctionDeclaration {
    public OCFunctionDeclarationImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.FUNCTION;
    }

    @Override
    @Nullable
    public OCDeclarator getDeclarator() {
        return (OCDeclarator)this.findChildByType(OCElementTypes.DECLARATOR);
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCType functionType;
        OCDeclarator declarator = this.getDeclarator();
        OCType oCType = functionType = declarator != null ? declarator.getType() : OCUnknownType.INSTANCE;
        if (functionType instanceof OCPointerType) {
            functionType = ((OCPointerType)functionType).getRefType();
        }
        return functionType instanceof OCFunctionType ? ((OCFunctionType)functionType).getReturnType() : OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public OCTypeElement getTrailingReturnTypeElement() {
        OCDeclaratorImpl declarator = (OCDeclaratorImpl)this.getDeclarator();
        if (declarator != null) {
            boolean wasDeref = false;
            for (ASTNode child : declarator.getNode().getChildren(null)) {
                IElementType elementType = child.getElementType();
                if (elementType == OCTokenTypes.DEREF) {
                    wasDeref = true;
                    continue;
                }
                if (elementType != OCElementTypes.TYPE_ELEMENT || !wasDeref) continue;
                return (OCTypeElement)child.getPsi();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public OCTypeElement getReturnTypeElement() {
        OCTypeElement typeElement = this.getTrailingReturnTypeElement();
        return typeElement != null ? typeElement : (OCTypeElement)this.findNotNullChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCParameterList getParameterList() {
        OCDeclaratorImpl declarator = (OCDeclaratorImpl)this.getDeclarator();
        if (declarator != null) {
            return (OCParameterList)declarator.findChildByType(OCElementTypes.PARAMETER_LIST);
        }
        return null;
    }

    @Override
    public List<OCDeclarator> getParameters() {
        OCParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getParameters() : null;
    }

    @Override
    public OCBlockStatement getBody() {
        return null;
    }

    @Override
    public boolean isPossibleStructMember() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null && declarator.isPossibleStructMember();
    }

    @Override
    public boolean isStatic() {
        return this.findChildByType(OCTokenTypes.STATIC_KEYWORD) != null;
    }

    @Override
    public boolean isOperator() {
        OCDeclarator declarator = this.getDeclarator();
        if (declarator == null) {
            return false;
        }
        return declarator.getNode().findChildByType((IElementType)OCTokenTypes.OPERATOR_CPP_KEYWORD) != null;
    }

    @Override
    @NotNull
    public CVQualifiers getCVQualifiers() {
        OCDeclaratorImpl declarator = (OCDeclaratorImpl)this.getDeclarator();
        boolean isConst = false;
        boolean isVolatile = false;
        if (declarator != null) {
            isConst = declarator.findChildByType(OCTokenTypes.CONST_KEYWORD) != null;
            isVolatile = declarator.findChildByType(OCTokenTypes.VOLATILE_KEYWORD) != null;
        }
        return CVQualifiers.get(isConst, isVolatile);
    }

    @Override
    public OCSymbolWithQualifiedName getSymbol() {
        return this.getContainingOCFile().findSymbol(this, OCSymbolWithQualifiedName.class);
    }

    @Override
    @NotNull
    public String getName() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.getName() : "";
    }

    @Override
    @NotNull
    public String getSymbolName() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.getSymbolName() : "";
    }

    @Override
    public PsiElement getNameIdentifier() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.getNameIdentifier() : null;
    }

    @Override
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.getNamespaceQualifier() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.setName(name) : this;
    }

    @Override
    public int getTextOffset() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.getTextOffset() : 0;
    }

    @Override
    public long getComplexOffset() {
        OCDeclarator declarator = this.getDeclarator();
        return declarator != null ? declarator.getComplexOffset() : 0L;
    }

    @Override
    @Nullable
    public OCElementsRange getHeaderRange() {
        OCBlockStatement body2 = this.getBody();
        OCElementsRange range = new OCElementsRange(this.getFirstChild(), body2 != null ? body2.getPrevSibling() : this.getLastChild());
        return range.trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitFunctionDeclaration(this);
    }

    @Override
    @NotNull
    public List<PsiElement> getVirtualSpecifiers() {
        ArrayList<PsiElement> result2 = null;
        for (PsiElement child = (declarator = this.getDeclarator()) != null ? declarator.getFirstChild() : null; child != null; child = child.getNextSibling()) {
            IElementType type2 = OCElementUtil.getElementType(child);
            if (!OCTokenTypes.CPP_VIRTUAL_SPECIFIERS.contains(type2)) continue;
            if (result2 == null) {
                result2 = new ArrayList<PsiElement>();
            }
            result2.add(child);
        }
        return result2 == null ? Collections.emptyList() : result2;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        OCDeclaratorImpl declarator = (OCDeclaratorImpl)this.getDeclarator();
        if (declarator != null) {
            return (OCNoexceptSpecifier)declarator.findChildByType(OCElementTypes.CPP_NOEXCEPT_SPECIFIER);
        }
        return null;
    }
}

