/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.impl.OCIncludeDirectiveImpl;
import com.jetbrains.cidr.lang.resolve.references.OCImportModuleReference;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCImportModuleStatementImpl
extends OCIncludeDirectiveImpl {
    public OCImportModuleStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiElement getHeaderToken() {
        Object importKeyword = this.findChildByType(OCTokenTypes.IMPORT_MODULE_KEYWORD);
        return importKeyword == null ? super.getHeaderToken() : importKeyword;
    }

    @NotNull
    private String getModuleName() {
        ArrayList parts = ContainerUtil.newArrayList();
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt != OCTokenTypes.IDENTIFIER) continue;
            parts.add(node.getText());
        }
        return StringUtil.join((Collection)parts, (String)".");
    }

    @Override
    @NotNull
    public OCIncludeDirective.Delimiters getDelimiters() {
        return OCIncludeDirective.Delimiters.NONE;
    }

    @Override
    public boolean isAngleBrackets() {
        return true;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        return new PsiReference[]{new OCImportModuleReference(this)};
    }

    @Override
    @NotNull
    public String getReferenceText() {
        return this.getModuleName();
    }

    @Override
    public boolean isValidDirective() {
        PsiReference[] references;
        for (PsiReference reference : references = this.getReferences()) {
            if (!(reference instanceof OCImportModuleReference) || ((OCImportModuleReference)reference).isValid()) continue;
            return false;
        }
        return references.length > 0;
    }
}

