/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCExternBlockImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCImportManipulator;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeDirectiveImpl
extends OCDirectiveImpl
implements OCIncludeDirective {
    private static final ElementManipulator<OCIncludeDirectiveImpl> ourManipulator = new OCImportManipulator();
    private CachedValue<PsiFile> myImportedFile;

    public OCIncludeDirectiveImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        return this.createRefSet().getAllReferences();
    }

    private static boolean shouldChangePath(@NotNull String candidate, @NotNull String existing) {
        return existing.contains("\\") || !FileUtil.toCanonicalPath((String)candidate, (boolean)false).equals(FileUtil.toCanonicalPath((String)existing, (boolean)false));
    }

    private FileReferenceSet createRefSet() {
        FileReferenceSet set2;
        Object headerPathContent = this.findChildByType(OCTokenTypes.HEADER_PATH_LITERAL);
        TextRange allContent = ((TextRange)this.getContent((boolean)true).second).shiftRight(-this.getTextRange().getStartOffset());
        if (headerPathContent instanceof OCMacroForeignLeafElement) {
            OCSymbol symbol = this.getSymbol();
            set2 = new FileReferenceSet(symbol.getName(), this, allContent.getStartOffset(), null, true, false);
        } else {
            set2 = FileReferenceSet.createSet(this, false, true, false);
        }
        return new FileReferenceSet(set2.getPathString(), this, set2.getStartInElement(), null, true, true, (PsiElement)headerPathContent, allContent){
            final /* synthetic */ PsiElement val$headerPathContent;
            final /* synthetic */ TextRange val$allContent;
            {
                this.val$headerPathContent = psiElement;
                this.val$allContent = textRange;
                super(arg0, arg1, arg2, arg3, arg4, arg5);
            }

            @Override
            public FileReference createFileReference(TextRange range, int index, String text) {
                return new FileReference(this, this.val$headerPathContent instanceof OCMacroForeignLeafElement ? this.val$allContent : range, index, text){
                    private OCAutoImportHelper.ImportSpecification newSpec;
                    private OCIncludeDirective.Delimiters newDelimiters;
                    {
                        this.newSpec = null;
                        this.newDelimiters = null;
                    }

                    @Override
                    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
                        class ImportProcessor
                        implements Processor<OCAutoImportHelper.ImportSpecification> {
                            public OCAutoImportHelper.ImportSpecification best = null;
                            public OCIncludeDirective.Delimiters bestDelimiters = null;
                            public boolean exactMatch = false;
                            public boolean renameOnly = false;

                            ImportProcessor() {
                            }

                            public boolean process(OCAutoImportHelper.ImportSpecification spec) {
                                OCIncludeDirective.Delimiters delims;
                                assert (!this.exactMatch && !this.renameOnly);
                                OCIncludeDirective.Delimiters currentDelimiters = OCIncludeDirectiveImpl.this.getDelimiters();
                                if (spec.areDelimitersAllowed(currentDelimiters)) {
                                    if (!OCIncludeDirectiveImpl.shouldChangePath(spec.getImportPath(), OCIncludeDirectiveImpl.this.getReferenceText())) {
                                        this.exactMatch = true;
                                    } else if (!OCIncludeDirectiveImpl.shouldChangePath(PathUtil.getParentPath((String)spec.getImportPath()), PathUtil.getParentPath((String)OCIncludeDirectiveImpl.this.getReferenceText()))) {
                                        this.renameOnly = true;
                                    }
                                    if (this.exactMatch || this.renameOnly) {
                                        this.best = spec;
                                        this.bestDelimiters = currentDelimiters;
                                        return false;
                                    }
                                }
                                OCIncludeDirective.Delimiters delimiters = delims = spec.areDelimitersAllowed(currentDelimiters) ? currentDelimiters : spec.getPreferredDelimiters();
                                if (this.best == null || this.bestDelimiters != currentDelimiters && delims == currentDelimiters) {
                                    this.best = spec;
                                    this.bestDelimiters = delims;
                                }
                                return true;
                            }
                        }
                        ImportProcessor processor2 = new ImportProcessor();
                        VirtualFile fileToImport = element instanceof PsiFile ? OCInclusionContextUtil.getVirtualFile((PsiFile)element) : null;
                        VirtualFile targetFile = OCInclusionContextUtil.getVirtualFile(OCIncludeDirectiveImpl.this.getContainingOCFile());
                        if (fileToImport != null && targetFile != null) {
                            OCResolveRootAndConfiguration configuration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(targetFile, OCIncludeDirectiveImpl.this.getProject());
                            OCIncludeHelpers.processImportSpecifications(OCIncludeDirectiveImpl.this.getProject(), configuration, targetFile, fileToImport, processor2);
                        }
                        if (processor2.best == null || processor2.exactMatch) {
                            return OCIncludeDirectiveImpl.this;
                        }
                        this.newSpec = processor2.best;
                        this.newDelimiters = processor2.bestDelimiters;
                        return super.bindToElement(element, absolute);
                    }

                    @Override
                    protected PsiElement rename(String newName) throws IncorrectOperationException {
                        if (this.newSpec == null || this.newDelimiters == null) {
                            OCLog.LOG.error("Invalid rename for include directive");
                            return super.rename(newName);
                        }
                        return super.rename(this.newSpec.getImportText(this.newDelimiters));
                    }

                    @Override
                    @NotNull
                    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
                        PsiFile file2;
                        OCIncludeSymbol include = OCIncludeDirectiveImpl.this.getContainingOCFile().findSymbol(OCIncludeDirectiveImpl.this, OCIncludeSymbol.class);
                        if (include != null && include.getTargetFile() != null && include.getTargetFile().isValid() && (file2 = PsiManager.getInstance((Project)OCIncludeDirectiveImpl.this.getProject()).findFile(include.getTargetFile())) != null) {
                            return new ResolveResult[]{new PsiElementResolveResult((PsiElement)file2)};
                        }
                        return super.innerResolve(caseSensitive, containingFile);
                    }
                };
            }

            @Override
            public boolean isCaseSensitive() {
                return SystemInfo.isFileSystemCaseSensitive;
            }

            @Override
            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return item -> {
                    OCIncludeHelpers.ShowInCompletion show = OCIncludeHelpers.showInCompletion(item);
                    if (show == OCIncludeHelpers.ShowInCompletion.SHOW) {
                        return true;
                    }
                    if (show == OCIncludeHelpers.ShowInCompletion.DON_NOT_SHOW) {
                        return false;
                    }
                    if (item instanceof PsiFile) {
                        return OCFileTypeHelpers.isHeaderFile(item.getName());
                    }
                    if (item instanceof PsiDirectory) {
                        return !".idea".equals(item.getName());
                    }
                    return false;
                };
            }
        };
    }

    private OCSymbol getSymbol() {
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCIncludeSymbol && symbol.getOffset() == OCIncludeDirectiveImpl.this.getTextOffset();
            }
        };
        OCFile file2 = this.getContainingOCFile();
        OCLanguageKind kind2 = file2.getKind();
        OCInclusionContext dummy = OCInclusionContext.empty(kind2, file2);
        ASTStructure structure = new ASTStructure(this.getNode());
        OCBuilderDriver<ASTNode> builderDriver = new OCBuilderDriver<ASTNode>(file2, dummy, structure, BuilderDriverBase.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)finder);
        builderDriver.processImportDirective(this.getNode());
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    @NotNull
    public String getReferenceText() {
        TextRange range = ourManipulator.getRangeInElement((PsiElement)this);
        return range.substring(this.getText());
    }

    @Override
    @NotNull
    public OCIncludeDirective.Delimiters getDelimiters() {
        return this.isAngleBrackets() ? OCIncludeDirective.Delimiters.ANGLE_BRACKETS : OCIncludeDirective.Delimiters.QUOTES;
    }

    @Override
    public boolean isAngleBrackets() {
        int startOffset = ourManipulator.getRangeInElement((PsiElement)this).getStartOffset();
        return startOffset > 0 && this.getText().charAt(startOffset - 1) == '<';
    }

    @Override
    public boolean isTopLevel() {
        return PsiTreeUtil.skipParentsOfType((PsiElement)this, (Class[])new Class[]{OCExternBlockImpl.class}) instanceof OCFile;
    }

    @Override
    public PsiFile getIncludedFile() {
        if (this.myImportedFile == null) {
            Project project2 = this.getProject();
            this.myImportedFile = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result((Object)this.findImportedFile(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker()}), true);
        }
        return (PsiFile)this.myImportedFile.getValue();
    }

    @Nullable
    private PsiFile findImportedFile() {
        PsiFileSystemItem item;
        FileReference fileRef = this.createRefSet().getLastReference();
        if (fileRef != null && (item = fileRef.resolve()) instanceof PsiFile) {
            return (PsiFile)item;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitImportDirective(this);
    }

    @Override
    public boolean isValidDirective() {
        if (this.getReferenceText().isEmpty()) {
            return false;
        }
        for (PsiReference reference : this.getReferences()) {
            if (reference.resolve() != null) continue;
            return false;
        }
        TextRange range = ourManipulator.getRangeInElement((PsiElement)this);
        String text = this.getText();
        char openChar = '\u0000';
        char closeChar = '\u0000';
        if (range.getStartOffset() > 0) {
            openChar = text.charAt(range.getStartOffset() - 1);
        }
        if (range.getEndOffset() < text.length()) {
            closeChar = text.charAt(range.getEndOffset());
        }
        if (openChar == '\"' && closeChar != '\"') {
            return false;
        }
        return openChar != '<' || closeChar == '>';
    }
}

