/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMacroCallImpl
extends OCElementBase
implements OCMacroCall {
    public OCMacroCallImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCReferenceElement getMacroReferenceElement() {
        return (OCReferenceElement)this.findChildByType(OCElementTypes.MACRO_REF);
    }

    @Override
    @Nullable
    public OCExpression getExpansionExpression() {
        OCMacroRange range;
        OCExpression next;
        OCMacroRange range2;
        OCMacroCallImpl element = this;
        PsiElement nextElement = element.getNextSibling();
        while (nextElement instanceof OCMacroCall) {
            element = nextElement;
            nextElement = element.getNextSibling();
        }
        PsiElement firstLeaf = OCMacroCallImpl.nextLeaf(element);
        OCExpression expression2 = (OCExpression)PsiTreeUtil.getContextOfType((PsiElement)firstLeaf, (Class[])new Class[]{OCExpression.class});
        while (!(expression2 == null || (range2 = OCElementUtil.getRangeInMacroCall(expression2)) != null && range2.getMacroCall().equals(this))) {
            expression2 = (OCExpression)PsiTreeUtil.getContextOfType((PsiElement)expression2, (Class[])new Class[]{OCExpression.class});
        }
        while (expression2 != null && (next = (OCExpression)PsiTreeUtil.getContextOfType((PsiElement)expression2, (Class[])new Class[]{OCExpression.class})) != null && (range = OCElementUtil.getRangeInMacroCall(next)) != null && range.getMacroCall().equals(this)) {
            expression2 = next;
        }
        return expression2;
    }

    @Override
    public PsiElement getLastExpansionLeaf() {
        PsiElement next;
        PsiElement leaf = this.getFirstExpansionLeaf();
        while (leaf != null && (next = OCMacroCallImpl.nextLeaf(leaf)) instanceof ForeignLeafPsiElement) {
            leaf = next;
        }
        return leaf;
    }

    @Override
    public PsiElement getFirstExpansionLeaf() {
        OCMacroCallImpl element = this;
        PsiElement nextElement = element.getNextSibling();
        while (nextElement instanceof OCMacroCall) {
            element = nextElement;
            nextElement = element.getNextSibling();
        }
        PsiElement firstLeaf = OCMacroCallImpl.nextLeaf(element);
        if (firstLeaf instanceof OCMacroForeignLeafElement) {
            return firstLeaf;
        }
        return null;
    }

    @Override
    public OCMacroSymbol resolveToSymbol() {
        OCMacroReferenceElementImpl macroRef = (OCMacroReferenceElementImpl)this.getMacroReferenceElement();
        if (macroRef == null) {
            return null;
        }
        OCSymbol symbol = macroRef.resolveToSymbol();
        return symbol instanceof OCMacroSymbol ? (OCMacroSymbol)symbol : null;
    }

    @Override
    public List<OCMacroCallArgument> getArguments() {
        return this.findChildrenByType(OCElementTypes.MACRO_ARGUMENT);
    }

    @Override
    @NotNull
    public OCMacroCall.ParameterCheckResult checkParameters(@NotNull OCMacroSymbol symbol) {
        int minArgCount;
        List<OCMacroCallArgument> args = this.getArguments();
        int argCount = args.size();
        if (!symbol.hasParameterList()) {
            return argCount == 0 ? new OCMacroCall.ParameterCheckResult(-1, -1) : new OCMacroCall.ParameterCheckResult(argCount, 0);
        }
        OCImmutableList<String> parameterNames = symbol.getParameterNames();
        if (parameterNames.isEmpty() && (argCount == 0 || argCount == 1 && OCElementUtil.isWhitespace(args.get(0)))) {
            return new OCMacroCall.ParameterCheckResult(0, 0);
        }
        boolean isVararg = symbol.isVararg();
        int n = minArgCount = isVararg ? parameterNames.size() - 1 : parameterNames.size();
        if (argCount < minArgCount || argCount > minArgCount && !isVararg) {
            return new OCMacroCall.ParameterCheckResult(argCount, minArgCount);
        }
        return new OCMacroCall.ParameterCheckResult(argCount, argCount);
    }

    @Override
    @NotNull
    public String getReplacementText() {
        PsiElement leaf = OCMacroCallImpl.nextLeaf(this);
        while (leaf instanceof PsiComment) {
            leaf = OCMacroCallImpl.nextLeaf(leaf);
        }
        StringBuilder answer = new StringBuilder();
        boolean wasIdent = false;
        while (leaf instanceof ForeignLeafPsiElement) {
            if (PsiTreeUtil.getContextOfType((PsiElement)leaf, (Class[])new Class[]{OCMacroCall.class}) == null) {
                IElementType type2 = ((ForeignLeafPsiElement)leaf).getElementType();
                if (type2 != OCTokenTypes.AT && (type2 == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(type2) || OCTokenTypes.LITERALS.contains(type2))) {
                    if (wasIdent) {
                        answer.append(' ');
                    }
                    wasIdent = true;
                } else {
                    wasIdent = false;
                }
                answer.append(leaf.getText());
            }
            leaf = OCMacroCallImpl.nextLeaf(leaf);
        }
        return answer.toString();
    }

    @Override
    public boolean processExpansionDependencies(@NotNull Processor<PsiElement> processor2) {
        return this.processExpansionDependenciesWithIdent(null, processor2);
    }

    @Override
    public boolean processExpansionDependenciesWithIdent(@Nullable String ident, @NotNull Processor<PsiElement> processor2) {
        PsiElement leaf = OCMacroCallImpl.nextLeaf(this);
        while (leaf instanceof PsiComment) {
            leaf = OCMacroCallImpl.nextLeaf(leaf);
        }
        HashSet processed2 = new HashSet();
        OCReferenceElement ref = this.getMacroReferenceElement();
        if (ref == null) {
            return true;
        }
        String macroName = ref.getName();
        while (leaf instanceof OCMacroForeignLeafElement && macroName.equals(((OCMacroForeignLeafElement)leaf).getMacroName())) {
            if (PsiTreeUtil.getContextOfType((PsiElement)leaf, (Class[])new Class[]{OCMacroCall.class}) == null) {
                if (ident == null || leaf.getText().equals(ident)) {
                    for (PsiElement parent = leaf; parent != null && !processed2.contains((Object)parent); parent = parent.getContext()) {
                        if (!processor2.process((Object)parent)) {
                            return false;
                        }
                        processed2.add((Object)parent);
                    }
                }
            }
            leaf = OCMacroCallImpl.nextLeaf(leaf);
        }
        return true;
    }

    @Nullable
    private static PsiElement nextLeaf(PsiElement node) {
        PsiElement leaf;
        while ((leaf = PsiTreeUtil.nextLeaf((PsiElement)node)) != null && !(leaf.getNode() instanceof LeafElement)) {
            node = leaf;
        }
        return leaf;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitMacroCall(this);
    }
}

