/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodImpl
extends OCElementBase
implements OCMethod {
    public OCMethodImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.METHOD;
    }

    @Override
    @NotNull
    public OCClassDeclaration getContainingClass() {
        OCClassDeclaration parent = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCClassDeclaration.class});
        assert (parent != null);
        return parent;
    }

    @Override
    public boolean isInstanceMethod() {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.MINUS) {
                return true;
            }
            if (tt != OCTokenTypes.PLUS) continue;
            return false;
        }
        return false;
    }

    @Override
    public void setStatic(boolean isStatic) {
        PsiElement psi = null;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.MINUS) {
                psi = node.getPsi();
                break;
            }
            if (tt != OCTokenTypes.PLUS) continue;
            psi = node.getPsi();
            break;
        }
        if (psi != null && psi.isWritable()) {
            psi.replace(OCElementFactory.binaryOperatorFromText(isStatic ? "+" : "-", psi));
        }
    }

    @Override
    @NotNull
    public String getSelector() {
        StringBuilder buf = new StringBuilder();
        List selectors = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        for (OCMethodSelectorPart selector2 : selectors) {
            buf.append(selector2.getSelectorPart());
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.getSelector();
    }

    public PsiElement getNameIdentifier() {
        OCMethodSelectorPart selector2 = (OCMethodSelectorPart)this.findChildByType(OCElementTypes.METHOD_SELECTOR_PART);
        return selector2 != null ? selector2.getSelectorIdentifier() : null;
    }

    @Override
    public int getTextOffset() {
        List selectors = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        if (selectors.isEmpty()) {
            return super.getTextOffset();
        }
        return ((OCMethodSelectorPart)selectors.get(0)).getTextRange().getStartOffset();
    }

    @Override
    public long getComplexOffset() {
        List selectors = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        if (selectors.isEmpty()) {
            return super.getComplexOffset();
        }
        return OCSymbolOffsetUtil.getComplexOffset((PsiElement)selectors.get(0));
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        PsiElement identifier = this.getParameters().get(0).getSelectorIdentifier();
        if (identifier != null) {
            OCElementUtil.replaceWithIdentifier(identifier, newName, this);
        }
        return this;
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCClassDeclaration clazz;
        OCType returnType;
        OCTypeElement typeElement = this.getReturnTypeElement();
        OCType oCType = returnType = typeElement != null ? typeElement.getType() : OCIdType.pointerToID(this.getProject());
        if (returnType instanceof OCReferenceType && returnType.getName().equals("instancetype") && (clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            return OCPointerType.to(OCReferenceType.fromText(clazz.getName()));
        }
        return returnType;
    }

    @Override
    @NotNull
    public OCType getRawReturnType() {
        OCTypeElement typeElement = this.getReturnTypeElement();
        return typeElement != null ? typeElement.getRawType() : OCIdType.pointerToID(this.getProject());
    }

    @Override
    @Nullable
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCParameterList getParameterList() {
        return null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return null;
    }

    @Override
    @NotNull
    public List<OCMethodSelectorPart> getParameters() {
        return this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
    }

    @Override
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitMethod(this);
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCMethodImpl.this.getSelector();
            }

            public String getLocationString() {
                ItemPresentation classPresentation = OCMethodImpl.this.getContainingClass().getPresentation();
                return classPresentation != null ? classPresentation.getPresentableText() : "";
            }

            public Icon getIcon(boolean open2) {
                return OCMethodImpl.this.getIcon(0);
            }
        };
    }

    @Override
    public OCMethodSymbol getSymbol() {
        OCClassSymbol clazz = this.getContainingClass().getSymbol();
        if (clazz != null) {
            final boolean isStatic = !this.isInstanceMethod();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol methodSymbol) {
                    return methodSymbol.isStatic() == isStatic;
                }
            };
            clazz.processMembers(this.getSelector(), OCMethodSymbol.class, processor2);
            return (OCMethodSymbol)processor2.getFoundValue();
        }
        return null;
    }

    @Override
    @NotNull
    public List<PsiElement> getSelectors() {
        ArrayList<PsiElement> selectors = new ArrayList<PsiElement>();
        for (OCMethodSelectorPart part : this.getParameters()) {
            if (part.getSelectorIdentifier() == null) continue;
            selectors.add(part.getSelectorIdentifier());
        }
        return selectors;
    }

    @Override
    public TextRange getHeaderRange() {
        List<PsiElement> selectors = this.getSelectors();
        if (selectors.isEmpty()) {
            return new TextRange(this.getTextRange().getStartOffset(), this.getTextRange().getStartOffset());
        }
        return new TextRange(selectors.get(0).getTextRange().getStartOffset(), selectors.get(selectors.size() - 1).getTextRange().getEndOffset());
    }
}

