/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertyAttributeImpl
extends OCElementWithReferenceBase
implements OCPropertyAttribute {
    public OCPropertyAttributeImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitPropertyAttribute(this);
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement ident = this.getNameIdentifier();
        return ident == null ? "<unnamed>" : ident.getText();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    @Nullable
    public PsiElement getValueElement() {
        List names = this.findChildrenByType(OCTokenTypes.IDENTIFIER);
        return names.size() == 2 ? (PsiElement)names.get(1) : null;
    }

    @Override
    @Nullable
    public String getValue() {
        PsiElement element = this.getValueElement();
        if (element == null) {
            return null;
        }
        String result2 = element.getText();
        return this.getName().equals("setter") && !result2.endsWith(":") ? result2 + ":" : result2;
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(OCTokenTypes.COLON);
    }

    @Override
    @Nullable
    public OCProperty getParentProperty() {
        PsiElement property;
        PsiElement list = this.getParent();
        if (list instanceof OCPropertyAttributesList && (property = list.getParent()) instanceof OCProperty) {
            return (OCProperty)property;
        }
        return null;
    }

    @Override
    public void setValue(String value2) {
        List names = this.findChildrenByType(OCTokenTypes.IDENTIFIER);
        if (names.size() == 2) {
            ((PsiElement)names.get(1)).replace(OCElementFactory.createIdentifier(value2, this));
        }
    }

    @Nullable
    protected PsiReference createReference() {
        PsiElement valueElement = this.getValueElement();
        String keyName = this.getName();
        if ((keyName.equals("getter") || keyName.equals("setter")) && valueElement != null) {
            return new AccessorMethodReference();
        }
        return null;
    }

    private class AccessorMethodReference
    implements OCReference {
        private AccessorMethodReference() {
        }

        @Override
        public OCSymbol resolveToSymbol() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                public boolean process(OCMethodSymbol symbol) {
                    if (!symbol.isStatic()) {
                        return super.process((Object)symbol);
                    }
                    return true;
                }
            };
            if (classSymbol != null) {
                classSymbol.processMembers(this.getCanonicalText(), OCMethodSymbol.class, finder);
            }
            return (OCSymbol)finder.getFoundValue();
        }

        @Nullable
        private OCImplementationSymbol getClassSymbol() {
            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), OCClassDeclaration.class);
            if (classDeclaration == null) {
                return null;
            }
            OCClassSymbol classSymbol = classDeclaration.getSymbol();
            if (classSymbol == null) {
                return null;
            }
            return classSymbol.getImplementation();
        }

        public PsiElement getElement() {
            return OCPropertyAttributeImpl.this;
        }

        public TextRange getRangeInElement() {
            return OCElementUtil.getRangeInParent(OCPropertyAttributeImpl.this.getValueElement());
        }

        public PsiElement resolve() {
            OCSymbol symbol = this.resolveToSymbol();
            return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
        }

        @NotNull
        public String getCanonicalText() {
            return OCPropertyAttributeImpl.this.getValue();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            if (!OCPropertyAttributeImpl.this.getName().equals(newElementName)) {
                return OCPropertyAttributeImpl.this.getValueElement().replace(OCElementFactory.createIdentifier(newElementName, OCPropertyAttributeImpl.this));
            }
            return this.getElement();
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            assert (symbol instanceof OCMethodSymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            OCSymbol refSymbol = this.resolveToSymbol();
            return symbol instanceof OCMethodSymbol && (Comparing.equal((Object)refSymbol, symbol) || Comparing.equal((Object)refSymbol, (Object)((OCMethodSymbol)symbol).getAssociatedSymbol()));
        }

        @NotNull
        public Object[] getVariants() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            boolean isSetter = OCPropertyAttributeImpl.this.getName().equals("setter");
            ArrayList result2 = new ArrayList();
            if (classSymbol != null) {
                classSymbol.processMembers(null, OCMethodSymbol.class, symbol -> {
                    if (symbol.isGetter() && !isSetter || symbol.isSetter() && isSetter) {
                        result2.add(SymbolLookupBuilderUtil.lookup(symbol).withInsertHandler(new BasicInsertHandler()));
                    }
                    return true;
                });
            }
            return result2.toArray();
        }

        public boolean isSoft() {
            return false;
        }
    }
}

