/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSelectorExpressionImpl
extends OCExpressionWithReferenceBase<OCPolyVariantReference<OCMethodSymbol>>
implements OCSelectorExpression {
    public OCSelectorExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getSelector() {
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCElementTypes.OBJC_KEYWORD || tt == OCTokenTypes.LPAR || tt == OCTokenTypes.RPAR || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) continue;
            builder.append(child.getText());
        }
        return builder.toString().trim();
    }

    @Override
    @NotNull
    public OCType getExpectedReturnType() {
        OCSendMessageExpression sendMessageExpr;
        if (OCSelectorAdHocResolver.getActionTargetContext(this) != null && (sendMessageExpr = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)this, OCSendMessageExpression.class)) != null && OCSelectorAdHocResolver.isPerformSelectorMethod(sendMessageExpr.getMessageSelector())) {
            return OCExpectedTypeUtil.getExpectedType(sendMessageExpr);
        }
        return OCVoidType.instance();
    }

    @Override
    public String getExpectedMethodSignature() {
        StringBuilder result2 = new StringBuilder();
        result2.append("-(");
        result2.append(this.getExpectedReturnType().getBestNameInContext(this));
        result2.append(")");
        String lastID = null;
        HashSet<String> paramNames = new HashSet<String>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.IDENTIFIER) {
                lastID = child.getText();
                result2.append(lastID);
                continue;
            }
            if (tt != OCTokenTypes.COLON && tt != OCTokenTypes.COLON2X) continue;
            for (int i2 = 0; i2 < (tt == OCTokenTypes.COLON2X ? 2 : 1); ++i2) {
                String paramName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, lastID, null, paramNames);
                paramNames.add(paramName);
                result2.append(":(id)").append(paramName).append(' ');
            }
        }
        return result2.toString();
    }

    @Override
    @NotNull
    public TextRange getSelectorRange() {
        TextRange range;
        int startOffset = 0;
        int endOffset = 0;
        ASTNode child = this.getNode().getFirstChildNode();
        ASTNode childPrev = null;
        IElementType ttPrev = null;
        int parentOffset = this.getNode().getStartOffset();
        while (child != null) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) {
                child = child.getTreeNext();
                continue;
            }
            if (ttPrev == OCTokenTypes.LPAR) {
                startOffset = child.getStartOffset();
            }
            if (tt == OCTokenTypes.RPAR) {
                endOffset = childPrev.getTextRange().getEndOffset();
            }
            childPrev = child;
            ttPrev = tt;
            child = child.getTreeNext();
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        return (range = new TextRange(startOffset, endOffset)).isEmpty() ? range : range.shiftRight(-parentOffset);
    }

    @Override
    public List<PsiElement> getSelectorParts() {
        return this.findChildrenByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitSelectorExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        return OCReferenceType.fromText("SEL");
    }

    @Override
    @NotNull
    protected OCPolyVariantReference<OCMethodSymbol> createReference() {
        return new SelectorReference();
    }

    private class SelectorReference
    extends OCPolyVariantReferenceImpl<OCMethodSymbol> {
        private SelectorReference() {
        }

        public PsiElement getElement() {
            return OCSelectorExpressionImpl.this;
        }

        public TextRange getRangeInElement() {
            return OCSelectorExpressionImpl.this.getSelectorRange();
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol instanceof OCPropertySymbol) {
                String selector2 = OCSelectorExpressionImpl.this.getSelector();
                return symbol.getName().equals(selector2) || OCNameSuggester.getObjCSetterFromGetter(symbol.getName()).equals(selector2);
            }
            if (!(symbol instanceof OCMethodSymbol)) {
                return false;
            }
            List<OCMethodSymbol> symbols = this.resolveToSymbols();
            return symbols.contains(symbol) || symbols.contains(((OCMethodSymbol)symbol).getAssociatedSymbol());
        }

        @Override
        @NotNull
        public List<OCMethodSymbol> resolveToSymbols() {
            OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(OCSelectorExpressionImpl.this);
            if (targetContext != null) {
                targetContext.setStaticDoesntMatter();
                return targetContext.getProbableResponders(OCSelectorExpressionImpl.this.getSelector(), OCSelectorExpressionImpl.this.getProject()).getAllResponders();
            }
            HashMap result2 = new HashMap();
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCSelectorExpressionImpl.this.getProject(), (Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol oldMethod;
                    OCMethodSymbol method2 = this.validateSymbol((OCMethodSymbol)symbol);
                    String parentName = ((OCClassSymbol)method2.getParent()).getPresentableName();
                    if (method2.getParent() instanceof OCProtocolSymbol) {
                        parentName = "protocol#" + parentName;
                    }
                    if ((oldMethod = (OCMethodSymbol)result2.get(parentName)) == null || oldMethod.getParent() instanceof OCImplementationSymbol && method2.getParent() instanceof OCInterfaceSymbol) {
                        result2.put(parentName, method2);
                    }
                }
                return true;
            }), OCSelectorExpressionImpl.this.getSelector());
            return new ArrayList<OCMethodSymbol>(result2.values());
        }

        private OCMethodSymbol validateSymbol(OCMethodSymbol symbol) {
            OCClassDeclarationBase parentDecl = (OCClassDeclarationBase)((OCClassSymbol)symbol.getParent()).locateDefinition();
            if (parentDecl == null) {
                return symbol;
            }
            CommonProcessors.FindFirstProcessor<OCMemberSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMemberSymbol>(){

                protected boolean accept(OCMemberSymbol symbol) {
                    return symbol instanceof OCMethodSymbol;
                }
            };
            OCResolveUtil.processMemberSymbols(symbol.getName(), parentDecl.getLastChild(), (Processor<? super OCMemberSymbol>)finder);
            return finder.isFound() ? (OCMethodSymbol)finder.getFoundValue() : symbol;
        }

        @NotNull
        public String getCanonicalText() {
            return OCSelectorExpressionImpl.this.getSelector();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            OCSelectorExpressionImpl element = OCSelectorExpressionImpl.this;
            newElementName = OCNameSuggester.isObjCSetter(OCSelectorExpressionImpl.this.getSelector()) && !OCNameSuggester.isObjCSetter(newElementName) ? OCNameSuggester.getObjCSetterFromGetter(newElementName) : newElementName;
            return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText("@selector(" + newElementName + ")", element));
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            assert (symbol instanceof OCMethodSymbol || symbol instanceof OCPropertySymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isSoft() {
            return false;
        }
    }
}

