/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStatementExpressionImpl
extends OCExpressionBase
implements OCStatementExpression {
    public OCStatementExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitStatementExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCBlockStatement body2 = this.getBody();
        if (body2 == null) {
            return OCVoidType.instance();
        }
        List<OCStatement> statements = body2.getStatements();
        if (statements == null || statements.isEmpty()) {
            return OCVoidType.instance();
        }
        OCStatement last = statements.get(statements.size() - 1);
        if (!(last instanceof OCExpressionStatement)) {
            return OCVoidType.instance();
        }
        OCExpression expression2 = ((OCExpressionStatement)last).getExpression();
        return expression2 == null ? OCVoidType.instance() : expression2.getType(context);
    }
}

