/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeBuilder;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class OCTypeElementImpl
extends OCElementBase
implements OCTypeElement {
    public OCTypeElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitTypeElement(this);
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.getRawType();
    }

    @Override
    @NotNull
    public OCType getRawType() {
        OCFile file2 = this.getContainingOCFile();
        ASTNode node = this.getNode();
        ASTNode childNode = node.getFirstChildNode();
        IElementType tt = OCElementUtil.getElementType(childNode);
        if (tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
            PsiElement[] children2 = this.getChildren();
            if (children2.length == 1 && children2[0] instanceof OCExpression) {
                return ((OCExpression)children2[0]).getType();
            }
            if (Arrays.stream(this.getNode().getChildren(null)).anyMatch(n -> n.getElementType() == OCTokenTypes.AUTO_KEYWORD)) {
                return new OCAutoType();
            }
            return OCUnknownType.INSTANCE;
        }
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        OCLanguageKind kind2 = file2.getKind();
        OCBuilderDriver<ASTNode> driver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(kind2, file2), new ASTStructure(node), OCBuilderDriver.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)collector);
        BuilderDriverBase.DeclarationContext context = new BuilderDriverBase.DeclarationContext(null, null, null, null, this, false);
        OCTypeBuilder typeBuilder = new OCTypeBuilder(kind2, file2.getProject(), context);
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        context = new BuilderDriverBase.DeclarationContext(null, null, parent, null, this, false);
        typeBuilder.setLocalContext(context);
        return driver.processTypeElement(node, typeBuilder, (Processor<OCSymbol>)collector, context);
    }

    @Override
    public int getArrayLengths() {
        return this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACKET})).length;
    }

    @Override
    public boolean isEmptyType() {
        PsiElement child = this.getFirstChild();
        return child == null || OCElementUtil.getElementType(child) == OCElementTypes.EMPTY_NAME;
    }
}

