/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCLightFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.SLRUSynchronizedCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileGlobalSymbolsCache {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache");
    private static final int CACHE_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    private final SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols> myCache = new SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols>(CACHE_SIZE, CACHE_SIZE){

        @Override
        @NotNull
        public OCFileGlobalSymbols createValue(OCFile key2) {
            return OCFileGlobalSymbols.buildSymbols((OCFileImpl)key2);
        }
    };
    private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> myLightCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(20, 20){

        @Override
        @NotNull
        public OCLightFileGlobalSymbols createValue(OCFile key2) {
            return OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key2, false);
        }
    };
    private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> myTypesOnlyCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(150, 150){

        @Override
        @NotNull
        public OCLightFileGlobalSymbols createValue(OCFile key2) {
            return OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key2, true);
        }
    };
    private long myModCount = -1L;

    public static OCFileGlobalSymbolsCache getInstance(Project project2) {
        return (OCFileGlobalSymbolsCache)project2.getComponent(OCFileGlobalSymbolsCache.class);
    }

    public OCFileGlobalSymbols forFile(OCFile file2) {
        return this.myCache.get(file2);
    }

    public OCNamespaceLikeSymbol lightTableForFile(OCFile file2) {
        OCFileGlobalSymbols symbols = this.myCache.getIfCached(file2);
        if (symbols != null) {
            return symbols;
        }
        return this.myLightCache.get(file2);
    }

    public OCNamespaceLikeSymbol typesOnlyTableForFile(OCFile file2) {
        OCFileGlobalSymbols symbols = this.myCache.getIfCached(file2);
        if (symbols != null) {
            return symbols;
        }
        OCLightFileGlobalSymbols lSymbols = this.myLightCache.getIfCached(file2);
        if (lSymbols != null) {
            return lSymbols;
        }
        return this.myTypesOnlyCache.get(file2);
    }

    public void clear() {
        this.myCache.clear();
        this.myLightCache.clear();
        this.myTypesOnlyCache.clear();
    }

    public OCFileGlobalSymbolsCache(MessageBus bus, PsiManager psiManager) {
        final PsiModificationTracker tracker = psiManager.getModificationTracker();
        bus.connect().subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                long current = tracker.getOutOfCodeBlockModificationCount();
                if (OCFileGlobalSymbolsCache.this.myModCount != current) {
                    OCFileGlobalSymbolsCache.this.myModCount = current;
                    OCFileGlobalSymbolsCache.this.clear();
                }
            }
        });
    }

    public static void processFile(OCFileImpl file2, Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        if (!OCFileGlobalSymbolsCache.processFileImpl(file2, symbols, importsMap) && !OCFileGlobalSymbolsCache.processFileImpl(file2, symbols, importsMap)) {
            LOG.error("Symbols were collected incorrectly");
        }
    }

    public static boolean processFileImpl(@NotNull OCFileImpl file2, Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        FileSymbolTable table;
        if (!FileSymbolTablesCache.areSymbolsLoaded(file2.getProject())) {
            return true;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        THashSet processed2 = new THashSet();
        List<Object> precompiledHeaders = Collections.emptyList();
        OCImmutableInclusionContext precompiledContext = null;
        OCInclusionContext initial = null;
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file2);
        PsiFile importHolder = context.getRootFile();
        OCResolveConfiguration configuration = context.getConfiguration();
        if (configuration != null) {
            OCLanguageKind contextKind = context.getLanguageKind();
            precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, contextKind, importHolder);
            precompiledHeaders = precompiledContext.getPrecompiledHeaders();
            initial = OCInclusionContext.beforePCHFileContext(configuration, contextKind, importHolder);
        }
        if (initial == null) {
            initial = OCInclusionContext.beforePCHFileContext(file2);
        }
        boolean contextWasProcessed = false;
        for (OCFile pch : precompiledHeaders) {
            FileSymbolTable tableForPch = FileSymbolTable.forFile(pch, initial);
            if (tableForPch == null) continue;
            if (!precompiledContext.isProcessed(virtualFile)) {
                tableForPch.processSymbols(symbols, null, (Set<FileSymbolTable>)processed2, importsMap, OCElementUtil.getFilePath(pch), initial, null);
                continue;
            }
            tableForPch.processSymbols(symbols, null, (Set<FileSymbolTable>)processed2, importsMap, OCElementUtil.getFilePath(pch), initial, virtualFile);
            contextWasProcessed = true;
            break;
        }
        if (!contextWasProcessed && file2.isHeader() && (table = FileSymbolTable.forFile(importHolder, initial)) != null) {
            VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(file2);
            table.processSymbols(symbols, null, (Set<FileSymbolTable>)processed2, importsMap, null, initial, vFile);
            if (initial.isProcessed(vFile)) {
                return false;
            }
        }
        if ((table = file2.getSymbolTable(initial)) != null) {
            table.processSymbols(symbols, null, (Set<FileSymbolTable>)processed2, importsMap, null, initial, null);
        }
        return true;
    }
}

