/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.SLRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SLRUSynchronizedCache<K, V> {
    @NotNull
    private final SLRUCache<K, AtomicNotNullLazyValue<V>> myCache;

    public SLRUSynchronizedCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUCache<K, AtomicNotNullLazyValue<V>>(protectedQueueSize, probationalQueueSize){

            @NotNull
            public AtomicNotNullLazyValue<V> createValue(final K key2) {
                return new AtomicNotNullLazyValue<V>(){

                    @NotNull
                    protected V compute() {
                        return SLRUSynchronizedCache.this.createValue(key2);
                    }
                };
            }
        };
    }

    public abstract V createValue(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public V get(K key2) {
        NotNullLazyValue value2;
        SLRUCache<K, AtomicNotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            value2 = (NotNullLazyValue)this.myCache.get(key2);
        }
        return (V)value2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V getIfCached(K key2) {
        AtomicNotNullLazyValue value2;
        SLRUCache<K, AtomicNotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            value2 = (AtomicNotNullLazyValue)this.myCache.getIfCached(key2);
        }
        if (value2 == null) {
            return null;
        }
        if (value2.isComputed()) {
            return (V)value2.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SLRUCache<K, AtomicNotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            this.myCache.clear();
        }
    }
}

