/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    private OCSymbol mySymbol;

    public OCAddInitializerIntentionAction(@Nullable OCDeclarator declarator, OCSymbol symbol) {
        super(declarator);
        this.mySymbol = symbol;
    }

    @Override
    protected String getTextInternal() {
        return "Initialize " + this.mySymbol.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return "Add initializers";
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (this.mySymbol != null) {
            OCType type2 = this.mySymbol.getResolvedType();
            return !(type2 instanceof OCStructType) || type2.isCppStructType() || ((OCStructType)type2).isEnum();
        }
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myElementPtr.getElement();
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        OCDeclarator declarator = (OCDeclarator)this.myElementPtr.getElement();
        if (declarator != null) {
            this.invoke(file2, declarator, editor);
        }
    }

    protected void invoke(PsiFile file2, @NotNull OCDeclarator declarator, Editor editor) {
        OCType type2 = this.mySymbol.getResolvedType();
        String declarationText = "int " + declarator.getTextWithMacros() + "=" + type2.getDefaultValue((PsiElement)file2);
        OCDeclaration declaration2 = OCElementFactory.declarationFromText(declarationText, (PsiElement)file2, true);
        declarator = (OCDeclarator)OCChangeUtil.replaceHandlingMacros(declarator, declaration2.getDeclarators().get(0));
        OCAddInitializerIntentionAction.invokeSmartCompletion(declarator.getInitializer(), type2);
    }

    public static void invokeSmartCompletion(final @NotNull OCExpression expression2, @NotNull OCType type2) {
        OCFile file2 = expression2.getContainingOCFile();
        final boolean deleteOnEsc = type2.isPointerToObjectCompatible() && !OCCompilerHelper.isArcDisabled(file2);
        TextRange initializerRange = expression2.getRangeWithMacros();
        final Editor editor = EditorHelper.openInEditor(expression2);
        if (editor == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(initializerRange.getEndOffset());
        editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file2.getProject().isDisposed() || !file2.isValid()) {
                return;
            }
            CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true);
            base.invokeCompletion(file2.getProject(), editor, 1, true, false);
            LookupEx lookup = LookupManager.getActiveLookup(editor);
            if (lookup != null) {
                lookup.addLookupListener(new LookupAdapter(){

                    @Override
                    public void lookupCanceled(LookupEvent event) {
                        if (deleteOnEsc && expression2.isValid()) {
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                Document document = PsiDocumentManager.getInstance((Project)expression2.getProject()).getDocument(expression2.getContainingFile());
                                if (document != null) {
                                    PsiDocumentManager.getInstance((Project)expression2.getProject()).commitDocument(document);
                                }
                                OCChangeUtil.delete(expression2);
                            });
                        } else {
                            editor.getSelectionModel().removeSelection();
                        }
                    }
                });
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }
}

