/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddRawStringSuffix
extends OCPsiElementQuickFix<PsiElement> {
    private final PsiElement myRawString;

    public OCAddRawStringSuffix(PsiElement element) {
        super(element);
        this.myRawString = element;
    }

    @Override
    protected String getTextInternal() {
        return "Add suffix";
    }

    @NotNull
    public String getFamilyName() {
        return "Check raw string";
    }

    @Override
    public boolean isAvailable() {
        return OCElementUtil.getElementType(this.myRawString) == OCTokenTypes.WRONG_RAW_STRING_LITERAL;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (editor != null && this.myRawString.getNode() != null) {
            OCFixer.needCorrectionLiteral(editor, this.myRawString.getNode(), true);
        }
    }
}

