/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCAddSuperProtocolIntentionAction
extends OCSymbolQuickFix<OCClassSymbol> {
    private String myProtocol;
    private boolean myPrivateCategoryMode;

    public OCAddSuperProtocolIntentionAction(OCClassSymbol anInterface, String protocol, boolean privateCategoryMode) {
        super(anInterface);
        this.myProtocol = protocol;
        this.myPrivateCategoryMode = privateCategoryMode;
    }

    @Override
    protected String getTextInternal(OCClassSymbol myInterface) {
        return "Adopt '" + this.myProtocol + "' by " + (this.myPrivateCategoryMode ? "private category '" + myInterface.getName() + "()'" : "class '" + myInterface.getName() + "'");
    }

    @NotNull
    public String getFamilyName() {
        return this.myPrivateCategoryMode ? "Adopt protocol by the class" : "Adopt protocol by the private category";
    }

    @Override
    protected boolean isAvailable(OCClassSymbol myInterface) {
        return this.myProtocol != null && myInterface != null && OCSearchScope.isInProjectSources(myInterface) && !myInterface.isPredeclaration();
    }

    @Override
    protected void invoke(OCClassSymbol symbol) {
        OCClassDeclaration declaration2 = OCElementUtil.resolveClassDeclaration(symbol);
        if (declaration2 == null) {
            return;
        }
        if (this.myPrivateCategoryMode) {
            OCClassDeclaration privateCategory = OCCodeInsightUtil.getPrivateCategory(declaration2);
            if (privateCategory == null) {
                privateCategory = OCElementFactory.interfaceByName(symbol.getName() + "()", declaration2);
                privateCategory = OCChangeUtil.addBefore((PsiElement)declaration2.getContainingFile(), privateCategory, declaration2);
            }
            declaration2 = privateCategory;
        }
        this.addProtocol(declaration2);
    }

    private void addProtocol(OCClassDeclaration declaration2) {
        new OCElementsMover().addBaseProtocol(declaration2, this.myProtocol);
    }
}

