/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class OCChangeFunctionSignatureIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private OCFunctionType myNewType;

    public OCChangeFunctionSignatureIntentionAction(OCSymbol functionSymbol, OCFunctionType newType) {
        super(functionSymbol);
        this.myNewType = newType;
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        String name = this.myNewType.getName(symbol.getContainingOCFile());
        return "Change signature of " + symbol.getNameWithKindLowercase() + " to '" + name + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Change function signature";
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol);
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        Object declarator = symbol.locateDefinition();
        if (!(declarator instanceof OCDeclarator) || !(declarator.getParent() instanceof OCFunctionDeclaration)) {
            return;
        }
        OCFunctionDeclaration function = (OCFunctionDeclaration)declarator.getParent();
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler(function, function, false, true, true, false);
        OCParameterList parameterList = ((OCDeclarator)declarator).getParameterList();
        if (parameterList == null) {
            return;
        }
        handler2.setReturnType(this.myNewType.getReturnType());
        HashSet<String> createdNames = new HashSet<String>();
        Iterator<OCType> newTypesItr = this.myNewType.getParameterTypes(true).iterator();
        ArrayList<Pair> newArguments = new ArrayList<Pair>();
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            OCDeclarator paramDecl = param.getDeclarator();
            String paramName = paramDecl != null ? paramDecl.getName() : null;
            handler2.removeParameter(0);
            if (paramName != null) {
                createdNames.add(paramName);
            }
            if (!newTypesItr.hasNext()) continue;
            newArguments.add(Pair.create((Object)(paramName != null ? paramName : ""), (Object)newTypesItr.next()));
        }
        while (newTypesItr.hasNext()) {
            OCType newType = newTypesItr.next();
            Collection<String> suggestedNames = OCNameSuggester.suggestForType(newType, declarator, createdNames);
            String suggestedName = suggestedNames.isEmpty() ? "param" : suggestedNames.iterator().next();
            createdNames.add(suggestedName);
            newArguments.add(Pair.create((Object)suggestedName, (Object)newType));
        }
        int index = 0;
        for (Pair argument : newArguments) {
            handler2.addParameter((String)argument.getFirst(), (OCType)argument.getSecond(), index++);
        }
        handler2.invokeSynchronously();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

