/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeGCCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private String myAttribute;
    private String myAttributeText;
    private boolean myEnable;
    private String myText;

    public OCChangeGCCAttributeIntentionAction(@Nullable OCSymbol symbol, String attribute, String attributeText, boolean enable) {
        super(symbol);
        this.myAttribute = attribute;
        this.myAttributeText = attributeText;
        this.myEnable = enable;
        if (symbol != null) {
            this.myText = (enable ? "Enable '" : "Disable '") + this.myAttributeText + "' for " + symbol.getNameWithKindLowercase();
        }
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return OCCodeInsightUtil.isValid(symbol.locateDefinition()) && this.myEnable ^ symbol.hasAttribute(this.myAttribute);
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return "Change attribute '" + this.myAttributeText + "'";
    }

    @Override
    protected void invoke(OCSymbol<?> symbol) {
        ArrayList definitions = new ArrayList();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
            Object definition = symbol1.locateDefinition();
            if (definition != null) {
                definitions.add(definition);
            }
            return true;
        }));
        for (PsiElement definition : definitions) {
            this.importFileContainingAttribute(definition);
            int offset = -1;
            if (definition instanceof OCDeclarator) {
                offset = definition.getTextRange().getStartOffset();
            } else if (definition instanceof OCStructLike) {
                offset = definition.getParent().getTextRange().getEndOffset();
            } else if (definition instanceof OCMethod) {
                List<OCMethodSelectorPart> parameters2 = ((OCMethod)definition).getParameters();
                if (!parameters2.isEmpty()) {
                    offset = parameters2.get(parameters2.size() - 1).getTextRange().getEndOffset();
                }
            } else if (definition instanceof OCMethodSelectorPart) {
                OCTypeElement typeElement = ((OCMethodSelectorPart)definition).getTypeElement();
                if (typeElement != null) {
                    offset = typeElement.getTextOffset();
                }
            } else if (definition instanceof OCLabeledStatement) {
                offset = definition.getTextOffset();
            } else assert (false) : definition.getClass();
            if (offset == -1) continue;
            if (this.myEnable) {
                OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), offset, 0, " " + this.myAttributeText + " ", true);
                continue;
            }
            int index = definition.getText().indexOf(this.myAttributeText);
            if (index == -1) continue;
            OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), definition.getTextRange().getStartOffset() + index, this.myAttributeText.length(), "", true);
        }
    }

    private void importFileContainingAttribute(PsiElement definition) {
        PsiFile file2 = definition.getContainingFile();
        OCResolveContext context = new OCResolveContext((PsiElement)file2);
        context.setProcessNonImported(true);
        OCSymbolReference.GlobalReference ref = OCSymbolReference.getGlobalReference(this.myAttributeText, null);
        List<OCSymbol> unusedSymbols = context.resolveToSymbols(ref);
        for (OCSymbol unused : unusedSymbols) {
            if (unused.getKind() == OCSymbolKind.MACRO && new OCImportSymbolFix((PsiElement)definition.getContainingFile(), unused).fixFirstItem(file2.getProject(), file2)) break;
        }
    }

    public static class SuppressFix
    extends SuppressIntentionAction {
        private OCChangeGCCAttributeIntentionAction myAction;

        public SuppressFix(OCSymbol symbol, String attribute, String attributeText, boolean enable) {
            this.myAction = new OCChangeGCCAttributeIntentionAction(symbol, attribute, attributeText, enable){

                @Override
                protected boolean isAvailable(OCSymbol symbol) {
                    return super.isAvailable(symbol) && this.isAvailable(symbol);
                }
            };
        }

        public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            this.myAction.invoke(project2, editor, element.getContainingFile());
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
            return this.myAction.isAvailable(project2, editor, element.getContainingFile());
        }

        protected boolean isAvailable(OCSymbol symbol) {
            return true;
        }

        @NotNull
        public String getFamilyName() {
            return this.myAction.getFamilyName();
        }

        @NotNull
        public String getText() {
            return this.myAction.getText();
        }

        public boolean startInWriteAction() {
            return this.myAction.startInWriteAction();
        }
    }
}

