/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodSignatureIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    private List<OCType> myNewParamTypes;
    private List<String> myNewSelectors;
    private List<OCExpression> myNewExpressions;

    public OCChangeMethodSignatureIntentionAction(OCMethodSymbol methodSymbol, List<OCType> newParamTypes, List<String> newSelectors, List<OCExpression> newExpressions) {
        super(methodSymbol);
        this.myNewParamTypes = newParamTypes;
        this.myNewSelectors = newSelectors;
        this.myNewExpressions = newExpressions;
    }

    @Override
    protected boolean isAvailable(OCMethodSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol);
    }

    @Override
    protected String getTextInternal(OCMethodSymbol symbol) {
        return "Add parameters to " + symbol.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return "Add parameters";
    }

    @Override
    protected void invoke(OCMethodSymbol symbol) {
        int i2;
        Object method2 = symbol.locateDefinition();
        if (!(method2 instanceof OCMethod)) {
            return;
        }
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCMethod)method2, method2, true);
        int oldSelectorsCnt = OCNameSuggester.isObjCGetter(symbol.getName()) ? 0 : symbol.getSelectors().size();
        HashSet prevParamNames = new HashSet();
        for (i2 = 0; i2 < oldSelectorsCnt; ++i2) {
            OCDeclaratorSymbol parameter = symbol.getSelectors().get(i2).getParameter();
            if (parameter == null) continue;
            prevParamNames.add(parameter.getName());
        }
        for (i2 = oldSelectorsCnt; i2 < this.myNewSelectors.size(); ++i2) {
            String selector2 = this.myNewSelectors.get(i2);
            OCExpression expression2 = this.myNewExpressions.get(i2);
            String paramName = OCNameSuggester.suggestForParameter((Collection<String>)prevParamNames, i2 == 0, selector2, this.myNewParamTypes.get(i2), symbol, expression2);
            prevParamNames.add(paramName);
            handler2.addParameter(selector2, paramName, this.myNewParamTypes.get(i2), -1, false);
        }
        handler2.invokeSynchronously();
    }
}

