/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodStaticnessIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    private boolean myMakeStatic;

    public OCChangeMethodStaticnessIntentionAction(OCMethodSymbol methodSymbol, boolean makeStatic) {
        super(methodSymbol);
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected String getTextInternal(OCMethodSymbol methodSymbol) {
        return "Make '" + methodSymbol.getPresentableName() + (this.myMakeStatic ? "' a class method" : "' an instance method");
    }

    @NotNull
    public String getFamilyName() {
        return "Make method instance/class";
    }

    @Override
    protected boolean isAvailable(OCMethodSymbol methodSymbol) {
        return OCSearchScope.isInProjectSources(methodSymbol) && methodSymbol.getGeneratedFromProperty() == null;
    }

    @Override
    protected void invoke(OCMethodSymbol methodSymbol) {
        this.processMethod(methodSymbol);
        this.processMethod(methodSymbol.getAssociatedSymbol());
    }

    private void processMethod(OCMethodSymbol symbol) {
        if (symbol == null) {
            return;
        }
        Object element = symbol.locateDefinition();
        if (element instanceof OCMethod && FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            OCMethod method2 = (OCMethod)element;
            method2.setStatic(this.myMakeStatic);
        }
    }
}

