/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInInterfaceIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeVisibilityIntentionAction
extends OCSymbolQuickFix<OCSymbolWithParent<?, ?>> {
    private OCVisibility myNewVisibility;
    private OCDeclaration myNewDeclaration;

    public OCChangeVisibilityIntentionAction(@Nullable OCSymbolWithParent symbol, OCVisibility newVisibility) {
        super(symbol);
        this.myNewVisibility = newVisibility;
    }

    @Override
    protected String getTextInternal(OCSymbolWithParent symbol) {
        return "Make " + symbol.getNameWithKindLowercase() + " " + (Object)((Object)this.myNewVisibility);
    }

    @NotNull
    public String getFamilyName() {
        return "Change visibility";
    }

    @Override
    protected boolean isAvailable(OCSymbolWithParent symbol) {
        return OCSearchScope.isInProjectSources(symbol) && this.myNewVisibility != null && (!(symbol instanceof OCInstanceVariableSymbol) || ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() == null);
    }

    @Override
    public void invoke(OCSymbolWithParent symbol) {
        if (symbol instanceof OCMethodSymbol && OCVisibility.shouldBeDeclaredInInterface(symbol, this.myNewVisibility)) {
            OCChangeVisibilityIntentionAction.makeMethodPublic((OCMethodSymbol)symbol);
        }
        if (symbol instanceof OCInstanceVariableSymbol || symbol instanceof OCSymbolWithQualifiedName) {
            Object declarator = symbol.locateDefinition();
            OCDeclaration newDeclaration = this.doChangeScope((PsiElement)declarator, symbol);
            if (symbol instanceof OCInstanceVariableSymbol) {
                OCInstanceVariableSymbol associatedSymbol = (OCInstanceVariableSymbol)symbol.getAssociatedSymbol();
                if (associatedSymbol != null) {
                    OCFile containingFile = associatedSymbol.getContainingOCFile();
                    if (containingFile != null && FileModificationService.getInstance().prepareFileForWrite((PsiFile)containingFile)) {
                        this.doChangeScope((PsiElement)associatedSymbol.locateDefinition(), symbol);
                    }
                } else if (OCVisibility.shouldBeDeclaredInInterface(symbol, this.myNewVisibility)) {
                    OCInterfaceSymbol anInterface;
                    Object parent = symbol.getParent();
                    OCInterfaceSymbol oCInterfaceSymbol = anInterface = parent instanceof OCInterfaceSymbol ? ((OCInterfaceSymbol)parent).getMainInterface() : ((OCImplementationSymbol)parent).getInterface();
                    if (anInterface != null && newDeclaration != null) {
                        OCFile containingFile = anInterface.getContainingOCFile();
                        OCClassDeclaration intfDeclaration = OCElementUtil.resolveClassDeclaration(anInterface);
                        if (intfDeclaration != null && containingFile != null && FileModificationService.getInstance().prepareFileForWrite((PsiFile)containingFile)) {
                            OCDeclaration oldDeclaration = newDeclaration;
                            newDeclaration = OCChangeUtil.add(intfDeclaration.getInstanceVariablesList(), newDeclaration);
                            this.putToParent(symbol, newDeclaration, intfDeclaration.getInstanceVariablesList());
                            OCChangeUtil.delete(oldDeclaration);
                        }
                    }
                }
            }
            this.myNewDeclaration = newDeclaration;
        }
    }

    public OCDeclaration getNewDeclaration() {
        return this.myNewDeclaration;
    }

    private static void makeMethodPublic(OCMethodSymbol symbol) {
        OCMethodSymbol implSymbol;
        if (!symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
            OCFile file2 = symbol1.getContainingOCFile();
            return file2 == null || !file2.isHeader();
        }))) {
            return;
        }
        OCMethodSymbol associatedSymbol = symbol.getAssociatedSymbol();
        PsiElement methodToDelete = null;
        if ("".equals(((OCClassSymbol)symbol.getParent()).getCategoryName())) {
            methodToDelete = (PsiElement)symbol.locateDefinition();
            implSymbol = associatedSymbol;
        } else if (associatedSymbol != null && "".equals(((OCClassSymbol)associatedSymbol.getParent()).getCategoryName())) {
            methodToDelete = (PsiElement)associatedSymbol.locateDefinition();
            implSymbol = symbol;
        } else {
            implSymbol = symbol;
        }
        OCFile file2 = symbol.getContainingOCFile();
        if (file2 == null) {
            return;
        }
        new OCDeclareMethodInInterfaceIntentionAction(){

            @Override
            @Nullable
            protected OCMethodSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                return implSymbol;
            }

            @Override
            @Nullable
            protected OCClassSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
                return implSymbol != null ? (OCClassSymbol)implSymbol.getParent() : null;
            }
        }.invoke(file2.getProject(), null, file2);
        if (methodToDelete != null) {
            OCChangeUtil.delete(methodToDelete);
        }
    }

    @Nullable
    private OCDeclaration putToBottomOfTheScope(PsiElement parent, OCDeclaration declaration2, PsiElement kid, OCSymbol symbol, boolean addScopeSpecifier) {
        while (kid != null && !OCElementUtil.isVisibilityKeyword(kid.getNode()) && OCElementUtil.getElementType(kid) != OCTokenTypes.RBRACE) {
            kid = kid.getNextSibling();
        }
        if (kid != null) {
            if (addScopeSpecifier) {
                if (symbol instanceof OCInstanceVariableSymbol) {
                    parent.addBefore(OCElementFactory.ivarScopeSpecifier(this.myNewVisibility, parent), kid);
                } else {
                    OCElementType elementType = this.myNewVisibility.getElementType();
                    if (elementType == null) {
                        return null;
                    }
                    parent.addBefore(OCElementFactory.create(elementType, parent), kid);
                    parent.addBefore(OCElementFactory.create(OCTokenTypes.COLON, parent), kid);
                }
                parent.addBefore(OCElementFactory.spaceFromText(parent), kid);
            }
            OCDeclaration result2 = (OCDeclaration)parent.addBefore((PsiElement)declaration2, kid);
            OCChangeUtil.delete(declaration2);
            return result2;
        }
        return null;
    }

    @Nullable
    private OCDeclaration doChangeScope(@Nullable PsiElement element, OCSymbolWithParent symbol) {
        Class parentClass = symbol instanceof OCInstanceVariableSymbol ? OCInstanceVariablesList.class : OCStruct.class;
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{parentClass});
        if (parent == null) {
            return null;
        }
        OCDeclaration declaration2 = null;
        if (element instanceof OCDeclarator) {
            declaration2 = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
        } else if (element instanceof OCStructLike) {
            declaration2 = (OCDeclaration)element.getParent().getParent();
        }
        if (declaration2 != null) {
            return this.putToParent(symbol, declaration2, parent);
        }
        return null;
    }

    @Nullable
    public OCDeclaration putToParent(OCSymbolWithParent symbol, OCDeclaration declaration2, PsiElement parent) {
        OCVisibility defaultVisibility;
        OCVisibility oCVisibility = defaultVisibility = parent instanceof OCStructLike ? ((OCStructLike)parent).getDefaultVisibility() : OCVisibility.getDefaultObjCVisibility(symbol.getKind());
        if (this.myNewVisibility == defaultVisibility) {
            return this.putToBottomOfTheScope(parent, declaration2, parent.getFirstChild(), symbol, false);
        }
        for (PsiElement kid = parent.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (this.myNewVisibility != OCVisibility.getVisibilityFromElement(kid)) continue;
            return this.putToBottomOfTheScope(parent, declaration2, kid.getNextSibling(), symbol, false);
        }
        return this.putToBottomOfTheScope(parent, declaration2, declaration2, symbol, true);
    }
}

