/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertTypeIntentionAction
extends OCPsiElementQuickFix<OCExpression>
implements HighPriorityAction {
    private OCType myType;

    public OCConvertTypeIntentionAction(OCExpression expression2, OCType type2) {
        super(expression2);
        this.myType = type2;
        OCType nsType = OCTollFreeBridges.getResolvedNSCounterpart(this.myType.getName(), expression2.getContainingFile());
        if (nsType != null && nsType instanceof OCPointerType) {
            this.myType = nsType;
        }
    }

    @Override
    protected String getTextInternal() {
        OCMethodSymbol method2 = this.getMethod();
        assert (method2 != null);
        return "Call " + method2.getNameWithParent();
    }

    @NotNull
    public String getFamilyName() {
        return "Convert type";
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression2) {
        return this.getMethod() != null;
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull OCExpression expression2) {
        OCMethodSymbol method2 = this.getMethod();
        if (method2 == null) {
            return;
        }
        String className = ((OCClassSymbol)method2.getParent()).getName();
        if (method2.getName().endsWith(":") && !method2.getName().equals("getValue:")) {
            OCSendMessageExpression sendMessageExpression = this.wrapWithMethodCall(expression2, null, method2.getName(), className, expression2, expression2);
            if (!method2.isStatic() && sendMessageExpression != null) {
                this.wrapWithMethodCall(sendMessageExpression.getReceiverExpression(), null, "alloc", className, null, expression2);
            }
        } else {
            this.wrapWithMethodCall(expression2, expression2, method2.getName(), className, null, expression2);
        }
    }

    @Nullable
    private OCSendMessageExpression wrapWithMethodCall(PsiElement oldElement, @Nullable PsiElement receiver2, String methodName, String className, @Nullable PsiElement argument, @NotNull OCExpression expression2) {
        OCSendMessageExpression sendMessageExpr;
        String receiverText;
        String string = receiverText = receiver2 != null ? receiver2.getText() : className;
        if (methodName.equals("getValue:")) {
            OCStatement curStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)oldElement, OCStatement.class);
            if (curStatement != null) {
                String varName = OCNameSuggester.suggestUniqueName(OCSymbolKind.LOCAL_VARIABLE, "value", oldElement);
                OCDeclarationStatement declaration2 = OCElementFactory.declarationStatement(varName, this.myType, null, oldElement);
                String sendMessageText = "[ " + receiverText + " " + methodName + "&" + varName + " ]";
                OCExpressionStatement unbox = (OCExpressionStatement)OCElementFactory.statementFromText(sendMessageText, oldElement);
                if (receiver2 != null) {
                    OCChangeUtil.replaceHandlingMacros(((OCSendMessageExpression)unbox.getExpression()).getReceiverExpression(), receiver2);
                }
                OCChangeUtil.addBefore(curStatement.getParent(), declaration2, curStatement);
                OCChangeUtil.addBefore(curStatement.getParent(), unbox, curStatement);
                OCChangeUtil.replaceHandlingMacros(oldElement, OCElementFactory.expressionFromText(varName, oldElement));
            }
            return null;
        }
        String argumentText = "";
        if (argument != null) {
            argumentText = argument.getText();
            PsiElement prevElement = argument.getPrevSibling();
            if (prevElement instanceof OCMacroCall) {
                argumentText = prevElement.getText() + argumentText;
            }
        }
        if (methodName.equals("value:withObjCType:")) {
            String typeName = expression2.getResolvedType().getBestNameInContext(oldElement);
            String sendMessageText = "[ " + receiverText + " value: " + argumentText + " withObjCType: @encode(" + typeName + ")]";
            sendMessageExpr = (OCSendMessageExpression)OCElementFactory.expressionFromText(sendMessageText, oldElement);
            if (receiver2 != null) {
                OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getReceiverExpression(), receiver2);
            }
            OCUnaryExpression addressExpr = (OCUnaryExpression)OCElementFactory.expressionFromText("&" + argumentText, oldElement);
            OCChangeUtil.replaceHandlingMacros(addressExpr.getOperand(), argument);
            OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getArguments().get(0).getArgumentExpression(), addressExpr);
        } else {
            String sendMessageText = "[ " + receiverText + " " + methodName + argumentText + " ] ";
            sendMessageExpr = (OCSendMessageExpression)OCElementFactory.expressionFromText(sendMessageText, oldElement);
            if (receiver2 != null) {
                OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getReceiverExpression(), receiver2);
            }
            if (argument != null) {
                OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getArguments().get(0).getArgumentExpression(), argument);
            }
        }
        return (OCSendMessageExpression)OCChangeUtil.replaceHandlingMacros(oldElement, sendMessageExpr);
    }

    @Nullable
    private OCMethodSymbol getMethod() {
        OCExpression expression2 = (OCExpression)this.myElementPtr.getElement();
        if (expression2 == null) {
            return null;
        }
        OCType exprType = expression2.getResolvedType().getGuessedType();
        if (this.myType.isPointerToObject()) {
            if (exprType.getName().startsWith("NS") && this.myType.getName().equals("NSMutable" + exprType.getName().substring(2))) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                ((OCObjectType)exprType.getTerminalType()).processMembers("mutableCopy", OCMethodSymbol.class, finder);
                return (OCMethodSymbol)finder.getFoundValue();
            }
            String prefix = exprType.isPointerToChar() ? "stringWith" : (exprType instanceof OCStructType ? "valueWith" : "numberWith");
            BoxingProcessor processor2 = new BoxingProcessor(exprType, prefix);
            ((OCObjectType)this.myType.getTerminalType()).processMembers(OCMethodSymbol.class, processor2);
            if (!processor2.isFound() && this.myType.isObjCRootType()) {
                OCType nsNumber = OCReferenceType.resolvedFromText("NSNumber", expression2.getContainingFile());
                OCType nsString = OCReferenceType.resolvedFromText("NSString", expression2.getContainingFile());
                if (nsNumber instanceof OCObjectType) {
                    ((OCObjectType)nsNumber).processMembers(OCMethodSymbol.class, processor2);
                }
                if (nsString instanceof OCObjectType) {
                    ((OCObjectType)nsString).processMembers(OCMethodSymbol.class, processor2);
                }
            }
            if (!processor2.isFound()) {
                processor2 = new BoxingProcessor(exprType, "initWith");
                ((OCObjectType)this.myType.getTerminalType()).processMembers(OCMethodSymbol.class, processor2);
            }
            return (OCMethodSymbol)processor2.getFoundValue();
        }
        if (exprType.isPointerToObject()) {
            OCType nsNumber;
            UnboxingProcessor processor3 = new UnboxingProcessor("Value");
            ((OCObjectType)exprType.getTerminalType()).processMembers(OCMethodSymbol.class, processor3);
            if (!processor3.isFound() && "id".equals(exprType.getName()) && (nsNumber = OCReferenceType.resolvedFromText("NSNumber", expression2.getContainingFile())) instanceof OCObjectType) {
                ((OCObjectType)nsNumber).processMembers(OCMethodSymbol.class, processor3);
            }
            return (OCMethodSymbol)processor3.getFoundValue();
        }
        return null;
    }

    private class UnboxingProcessor
    extends CommonProcessors.FindFirstProcessor<OCMethodSymbol> {
        private final String myMethodSuffix;

        public UnboxingProcessor(String methodSuffix) {
            this.myMethodSuffix = methodSuffix;
        }

        public boolean process(OCMethodSymbol method2) {
            if (method2.getName().equals("pointerValue") && OCConvertTypeIntentionAction.this.myType instanceof OCPointerType && !OCConvertTypeIntentionAction.this.myType.isPointerToObject() && OCTollFreeBridges.getNSCounterpart(OCConvertTypeIntentionAction.this.myType.getName()) == null || method2.getName().equals("getValue:") && OCConvertTypeIntentionAction.this.myType instanceof OCStructType && !OCTollFreeBridges.hasCFCounterpart(OCConvertTypeIntentionAction.this.myType.getName()) || method2.getName().endsWith(this.myMethodSuffix) && method2.getReturnType().equalsWithAliasName(OCConvertTypeIntentionAction.this.myType, (PsiElement)OCConvertTypeIntentionAction.this.myElementPtr.getContainingFile()) && !method2.isStatic()) {
                return super.process((Object)method2);
            }
            return true;
        }
    }

    private class BoxingProcessor
    extends CommonProcessors.FindFirstProcessor<OCMethodSymbol> {
        private final OCType myExprType;
        private final String myMethodPrefix;

        public BoxingProcessor(OCType exprType, String methodPrefix) {
            this.myExprType = exprType;
            this.myMethodPrefix = methodPrefix;
        }

        public boolean process(OCMethodSymbol method2) {
            OCType declType;
            OCDeclaratorSymbol declarator;
            if (method2.getName().equals("valueWithPointer:") && this.myExprType instanceof OCPointerType && OCTollFreeBridges.getNSCounterpart(this.myExprType.getName()) == null || method2.getName().equals("value:withObjCType:") && this.myExprType instanceof OCStructType && !OCTollFreeBridges.hasCFCounterpart(this.myExprType.getName())) {
                return super.process((Object)method2);
            }
            if (method2.getName().startsWith(this.myMethodPrefix) && method2.getSelectors().size() == 1 && !method2.isDeprecated() && (declarator = method2.getSelectors().get(0).getParameter()) != null && ((declType = declarator.getResolvedType()).equalsWithAliasName(this.myExprType, (PsiElement)OCConvertTypeIntentionAction.this.myElementPtr.getContainingFile()) || declType instanceof OCPointerType && Comparing.equal((String)declType.getAliasName(), (String)this.myExprType.getAliasName()) && ((OCPointerType)declType).validateConstPointers(this.myExprType, OCConvertTypeIntentionAction.this.myElementPtr.getElement()).getState() == OCType.TypeCheckState.OK)) {
                return super.process((Object)method2);
            }
            return true;
        }
    }
}

