/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCopyElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    private String myIntentionName;
    private SmartPsiElementPointer mySourceElementPtr;
    private String myFamilyName;

    public OCCopyElementIntentionAction(PsiElement sourceElement, PsiElement destinationElement, String intentionName) {
        this(sourceElement, destinationElement, intentionName, intentionName);
    }

    public OCCopyElementIntentionAction(PsiElement sourceElement, PsiElement destinationElement, String intentionName, String familyName) {
        super(destinationElement);
        this.mySourceElementPtr = OCElementUtil.createPsiElementPointer(sourceElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement destinationElement) {
        return OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr) != null;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myElementPtr.getElement();
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement destinationElement = this.myElementPtr.getElement();
        Object sourceElement = OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr);
        destinationElement.replace(sourceElement);
    }
}

