/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCppClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewProtocolAction;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseIntroduceHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceIvarAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceParameterAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroducePropertyAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceVariableAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCreateNewDefinitionIntentionAction
extends OCCreateDefinitionIntentionAction {
    private String myName;
    private OCType myType;
    private OCObjectType myReceiverType;
    private OCPropertySymbol myPropertySymbol;
    private OCExpectedTypeUtil.Expectable myExpectableType;
    private boolean myIsStaticMember;
    private boolean mySilentMode = ApplicationManager.getApplication().isUnitTestMode();
    private String myMessageSignature;

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement usage, @Nullable OCPropertySymbol propertySymbol, OCSymbol parent, String name, OCType type2, boolean staticMember) {
        super(symbolKind, usage, parent);
        this.myName = name;
        this.myType = type2;
        this.myPropertySymbol = propertySymbol;
        this.myIsStaticMember = staticMember;
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement usage, OCSymbol parent, String name, OCType type2) {
        this(symbolKind, usage, null, parent, name, type2, false);
    }

    public OCCreateNewDefinitionIntentionAction(PsiElement usage, OCSymbol parent, String name, String messageSignature, OCType returnType, @Nullable OCObjectType receiverType) {
        this(OCSymbolKind.METHOD, usage, null, parent, name, returnType, false);
        this.myMessageSignature = messageSignature;
        this.myReceiverType = receiverType;
        if (receiverType instanceof OCIdType) {
            this.myParent = null;
            for (OCProtocolSymbol protocolSymbol : receiverType.getAllProtocols()) {
                if (!OCSearchScope.isInProjectSources(protocolSymbol) || protocolSymbol.isPredeclaration()) continue;
                this.myParent = protocolSymbol;
                break;
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            OCSymbol parentInProject = this.getParentInProject();
            this.myParent = parentInProject != null ? parentInProject : this.myParent;
        }
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolContext symbolContext, PsiElement usage, String name) {
        super(symbolContext.getSymbolKind(), usage, symbolContext.getParent());
        this.myName = name;
        this.myExpectableType = symbolContext.getExpectable();
        this.myIsStaticMember = symbolContext instanceof OCSymbolContext.StructMemberContext && ((OCSymbolContext.StructMemberContext)symbolContext).isStatic();
        this.myPropertySymbol = null;
    }

    public void setSilentMode(boolean silentMode) {
        this.mySilentMode = silentMode;
    }

    @NotNull
    public String getText() {
        String subject = "";
        if (this.mySymbolKind == OCSymbolKind.INTERFACE) {
            subject = "class";
        } else {
            if (this.myIsStaticMember) {
                switch (this.mySymbolKind) {
                    case INSTANCE_VARIABLE: 
                    case PROPERTY: 
                    case METHOD: {
                        subject = "class ";
                        break;
                    }
                    default: {
                        subject = "static ";
                    }
                }
            }
            subject = this.mySymbolKind == OCSymbolKind.STRUCT ? "C++ class" : subject + this.mySymbolKind.getNameLowercase();
        }
        StringBuilder builder = new StringBuilder();
        if (this.myParent != null && this.myReceiverType != null && this.getParentInProject() == null) {
            builder.append("Create new category on ").append(this.myParent.getName()).append(" with ");
        } else {
            builder.append("Create new ");
        }
        builder.append(subject).append(" '");
        if (this.mySymbolKind.isFunctionOrConstructor() && this.myType instanceof OCFunctionType) {
            builder.append(OCTypeNameVisitor.getFunctionSignature(this.myUsage, (OCFunctionType)this.myType, this.myName, false, null));
        } else {
            builder.append(this.myName);
        }
        return builder.append("'").toString();
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (this.myName == null || !OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent) && this.mySymbolKind != OCSymbolKind.METHOD) {
            return false;
        }
        if (!this.mySymbolKind.isClass() && this.mySymbolKind != OCSymbolKind.STRUCT && this.myUsage instanceof OCReferenceElement && !(this.myUsage.getParent() instanceof OCReferenceExpression) && !(this.myUsage.getParent() instanceof OCSynthesizeProperty)) {
            return false;
        }
        if (this.myType == null && this.myExpectableType != null) {
            this.myType = this.myExpectableType.getExpectedType();
        }
        boolean isFunctionType = this.myType instanceof OCFunctionType;
        switch (this.mySymbolKind) {
            case CPP_CONSTRUCTOR_DECLARATION: {
                if (!isFunctionType || this.myParent == null || this.myParent.isPredeclaration()) {
                    return false;
                }
                if (this.myUsage instanceof OCReferenceExpression) {
                    this.myUsage = ((OCReferenceExpression)this.myUsage).getReferenceElement();
                }
                return !(this.myUsage instanceof OCReferenceElement) || ((OCReferenceElement)this.myUsage).getName().equals(this.myParent.getName());
            }
            case FUNCTION_DECLARATION: {
                return isFunctionType && (this.myParent == null || !this.myParent.isPredeclaration());
            }
            case PARAMETER: {
                return this.myParent != null && !isFunctionType;
            }
            case METHOD: {
                return (this.myParent == null || this.myParent instanceof OCClassSymbol && !this.myParent.isPredeclaration()) && this.myMessageSignature != null && (this.myMessageSignature.startsWith("+") || this.myMessageSignature.startsWith("-"));
            }
            case INTERFACE: 
            case PROTOCOL: {
                return (file2 == null || file2 instanceof OCFile && ((OCFile)file2).getKind().isObjC()) && OCNewFileActionBase.isNewFileActionSupported() && !ApplicationManager.getApplication().isUnitTestMode();
            }
            case STRUCT: {
                return (file2 == null || file2 instanceof OCFile && ((OCFile)file2).getKind().isCpp()) && OCNewFileActionBase.isNewFileActionSupported() && !ApplicationManager.getApplication().isUnitTestMode();
            }
            case INSTANCE_VARIABLE: 
            case PROPERTY: {
                if (this.myParent != null && !this.myParent.isPredeclaration()) break;
                return false;
            }
        }
        return super.isAvailable(project2, editor, file2) && this.myType != null && !isFunctionType;
    }

    @Nullable
    private OCSymbol getParentInProject() {
        if (this.myParent == null || OCSearchScope.isInProjectSources(this.myParent) || this.myReceiverType == null) {
            return this.myParent;
        }
        for (OCProtocolSymbol oCProtocolSymbol : this.myReceiverType.getAugmentedProtocols()) {
            if (!OCSearchScope.isInProjectSources(oCProtocolSymbol)) continue;
            return oCProtocolSymbol;
        }
        for (OCInterfaceSymbol oCInterfaceSymbol : this.myReceiverType.getCategoryInterfaces()) {
            if (!OCSearchScope.isInProjectSources(oCInterfaceSymbol)) continue;
            return oCInterfaceSymbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCreate(final Project project2, Editor editor, final PsiFile file2) {
        OCNewFileActionBase action = null;
        OCBaseIntroduceHandler introduceHandler = null;
        if (this.mySymbolKind == OCSymbolKind.INTERFACE) {
            action = new OCNewClassAction();
        } else if (this.mySymbolKind == OCSymbolKind.PROTOCOL) {
            action = new OCNewProtocolAction();
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT) {
            action = new OCNewCppClassAction();
            this.createCppConstructor(action);
        } else if (this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceVariableAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.PARAMETER) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceParameterAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceIvarAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.PROPERTY) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroducePropertyAction().getHandler();
        } else {
            if (this.mySymbolKind.isFunctionOrConstructor()) {
                return this.createFunction(file2);
            }
            if (this.mySymbolKind == OCSymbolKind.METHOD) {
                return this.createMethod();
            }
            return super.doCreate(project2, editor, file2);
        }
        if (introduceHandler != null) {
            OCBaseIntroduceHandler finalIntroduceHandler = introduceHandler;
            Runnable runnable2 = () -> {
                OCElement usage = null;
                if (this.mySymbolKind == OCSymbolKind.PROPERTY || this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
                    usage = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCElement.class, (boolean)false);
                } else if (this.myUsage instanceof OCReferenceElement && this.myUsage.getParent() instanceof OCReferenceExpression) {
                    usage = (OCReferenceExpression)this.myUsage.getParent();
                }
                if (usage != null) {
                    finalIntroduceHandler.invoke(project2, editor, usage, this.myType.resolve(file2), true, false, this.myName, this.myParent);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2);
            }
            return true;
        }
        if (action != null && action.performAction(project2, file2.getParent(), file2, this.myName) == null) {
            return false;
        }
        if (this.myUsage instanceof OCReferenceElement && this.myUsage.getText().equals(this.myName)) {
            final OCImportSymbolFix importFix = new OCImportSymbolFix((OCReferenceElement)this.myUsage);
            try {
                OCFormattingModelBuilder.requestAlwaysCreateFullModel();
                new WriteCommandAction(project2, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        importFix.fixFirstItem(project2, file2);
                    }
                }.execute();
            }
            finally {
                OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
            }
        }
        return true;
    }

    private void createCppConstructor(OCNewFileActionBase action) {
        OCArgumentList argumentList;
        PsiElement constructorUsage;
        PsiElement parent = this.myUsage.getParent();
        if (parent instanceof OCReferenceExpression && parent.getParent() instanceof OCCallExpression) {
            constructorUsage = parent;
            argumentList = ((OCCallExpression)parent.getParent()).getArgumentList();
        } else if (parent.getParent() instanceof OCCppNewExpression) {
            constructorUsage = parent.getParent();
            argumentList = ((OCCppNewExpression)constructorUsage).getArgumentList();
        } else {
            constructorUsage = null;
            argumentList = null;
        }
        if (argumentList != null) {
            action.addAuxAction(createdElements -> {
                PsiFile psiFile;
                OCSymbol clazz = null;
                PsiFile[] psiFileArray = createdElements;
                int n = psiFileArray.length;
                for (int j = 0; j < n && (clazz = ((OCFile)(psiFile = psiFileArray[j])).getSameNamedClass()) == null; ++j) {
                }
                if (clazz != null) {
                    OCFunctionType type2 = new OCFunctionType(OCVoidType.instance(), argumentList.getArgumentTypes(new OCResolveContext(this.myUsage)));
                    OCCreateNewDefinitionIntentionAction constructorAction = new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, constructorUsage, clazz, this.myName, type2);
                    constructorAction.setSilentMode(true);
                    OCFile file2 = clazz.getContainingOCFile();
                    if (constructorAction.isAvailable(file2.getProject(), null, file2)) {
                        constructorAction.invoke(file2.getProject(), null, file2);
                    }
                }
            });
        }
    }

    private boolean createMethod() {
        PsiElement parent;
        if (this.myType == null || this.myType == OCUnknownType.INSTANCE) {
            this.myType = OCVoidType.instance();
        }
        PsiElement insertionPoint = (parent = OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage)) != null ? OCChangeUtil.getRealAnchorForInsertion(parent, this.myUsage) : null;
        insertionPoint = insertionPoint != null ? insertionPoint : this.myUsage;
        OCMethod method2 = (OCMethod)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<OCMethod>(){

            public OCMethod compute() {
                String functionText = OCCallableUtil.methodWithSignature(OCCreateNewDefinitionIntentionAction.this.myType, OCCreateNewDefinitionIntentionAction.this.myMessageSignature, OCCreateNewDefinitionIntentionAction.this.myUsage);
                return OCElementFactory.methodFromText(functionText, OCCreateNewDefinitionIntentionAction.this.myUsage, true);
            }
        });
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)method2, insertionPoint);
        handler2.getGeneratedInfo().setMethodReference(this.myUsage);
        List auxParents = this.myReceiverType != null ? this.myReceiverType.getAugmentedProtocols() : Collections.emptyList();
        handler2.setParentClass(this.myParent, true, auxParents);
        handler2.setChangeUsages(false);
        handler2.getGeneratedInfo().setSelectMethod(!this.mySilentMode);
        handler2.setTitle("Create new method");
        handler2.setRefactorButtonText("Create");
        if (this.myParent == null || this.myReceiverType == null) {
            handler2.setChangeParentClassPossible(true);
        }
        if (this.mySilentMode) {
            handler2.invokeSynchronously();
        } else {
            handler2.invoke();
        }
        return true;
    }

    private boolean createFunction(final PsiFile file2) {
        OCSymbolWithQualifiedName callerParent;
        if (!(this.myType instanceof OCFunctionType)) {
            return false;
        }
        Object parent = this.myParent != null ? this.myParent.locateDefinition() : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
        OCFunctionDefinition caller = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCFunctionDefinition.class);
        OCFunctionSymbol callerSymbol = caller != null ? caller.getSymbol() : null;
        PsiElement insertionPoint = OCChangeUtil.getRealAnchorForInsertion(parent, this.myUsage);
        PsiElement psiElement = insertionPoint = insertionPoint != null ? insertionPoint : this.myUsage;
        if (callerSymbol != null && (callerParent = callerSymbol.getResolvedOwner()) != null && callerParent.isSameSymbol(this.myParent)) {
            this.myType = this.myType.cloneWithAddedCVQualifiers(callerSymbol.getType().getCVQualifiers(), caller.getProject());
        }
        final String signature = this.getFunctionSignature(insertionPoint);
        OCCallable function = (OCCallable)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<OCCallable>(){

            public OCCallable compute() {
                OCDeclaration declaration2;
                if (OCCreateNewDefinitionIntentionAction.this.mySymbolKind.isConstructorOrDestructor()) {
                    declaration2 = OCElementFactory.constructorFromText(signature, (PsiElement)file2, true);
                } else if (OCCreateNewDefinitionIntentionAction.this.myParent instanceof OCStructSymbol) {
                    declaration2 = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(signature, (PsiElement)file2, true);
                } else {
                    String functionText = OCCallableUtil.functionWithSignature(((OCFunctionType)OCCreateNewDefinitionIntentionAction.this.myType).getReturnType(), signature, OCCreateNewDefinitionIntentionAction.this.myUsage);
                    declaration2 = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(functionText, (PsiElement)file2, true);
                }
                OCLog.LOG.assertTrue(declaration2 instanceof OCCallable, (Object)declaration2.getTextWithMacros());
                return (OCCallable)((Object)declaration2);
            }
        });
        OCChangeSignatureHandler handler2 = this.mySymbolKind.isConstructorOrDestructor() ? OCChangeSignatureActionHandler.getHandler(function, insertionPoint, false, this.mySilentMode, !this.mySilentMode, true) : OCChangeSignatureActionHandler.getHandler(function, insertionPoint, this.mySilentMode);
        handler2.getGeneratedInfo().setMethodReference(this.myUsage);
        handler2.setParentClass(this.myParent, false, Collections.emptyList());
        handler2.getGeneratedInfo().setSelectMethod(!this.mySilentMode);
        handler2.setTitle(this.mySymbolKind.isConstructorOrDestructor() ? "Create new constructor" : "Create new function");
        handler2.setRefactorButtonText("Create");
        if (this.mySilentMode) {
            handler2.invokeSynchronously();
        } else {
            handler2.invoke();
        }
        return true;
    }

    protected String getFunctionSignature(PsiElement insertionPoint) {
        StringBuilder signature = new StringBuilder();
        if (!this.mySymbolKind.isConstructorOrDestructor()) {
            if (this.myIsStaticMember) {
                signature.append("static ");
            }
            signature.append(((OCFunctionType)this.myType).getReturnType().getBestNameInContext(insertionPoint));
            signature.append(' ');
        }
        signature.append(this.myName);
        List<OCExpression> arguments = this.myUsage instanceof OCReferenceElement && this.myUsage.getParent().getParent() instanceof OCCallExpression ? ((OCCallExpression)this.myUsage.getParent().getParent()).getArguments() : null;
        return OCTypeNameVisitor.getFunctionSignature(insertionPoint, (OCFunctionType)this.myType, signature.toString(), true, arguments);
    }

    @Override
    @Nullable
    public PsiElement getDefinition(Project project2, Editor editor, PsiFile file2) {
        switch (this.mySymbolKind) {
            case INSTANCE_VARIABLE: 
            case GLOBAL_VARIABLE: 
            case LOCAL_VARIABLE: {
                ARCAttribute ivarAttribute;
                OCPropertySymbol.PropertyAttribute propAttribute;
                OCType type2;
                String modifier = null;
                OCType oCType = type2 = this.myPropertySymbol != null ? this.myPropertySymbol.getResolvedType() : null;
                if (this.myPropertySymbol instanceof OCPropertySymbol && OCCompilerHelper.isArcEnabled(file2) && type2.isPointerToObjectCompatible() && (propAttribute = this.myPropertySymbol.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type2, (PsiElement)file2)) != null && !(ivarAttribute = propAttribute.getIvarCompatibleARCAttribute()).isDefault()) {
                    modifier = ivarAttribute.getTokenName();
                }
                return OCElementFactory.declaration(modifier, this.myName, this.myType, this.myUsage);
            }
            case STRUCT_FIELD: 
            case ENUM_CONST: {
                if (this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM) {
                    return OCElementFactory.enumConst(this.myName, (PsiElement)file2);
                }
                return OCElementFactory.declaration(this.myIsStaticMember ? "static" : null, this.myName, this.myType, this.myUsage);
            }
            case PROPERTY: {
                return OCElementFactory.propertyDeclaration(this.myName, this.myType.resolve(file2), (PsiElement)file2);
            }
            case MACRO: {
                return OCElementFactory.macroDeclarationFromText(this.myName, this.myType.resolve(file2).getDefaultValue((PsiElement)file2), file2);
            }
        }
        return null;
    }

    @Override
    public boolean startInWriteAction() {
        switch (this.mySymbolKind) {
            case INSTANCE_VARIABLE: 
            case PROPERTY: 
            case METHOD: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case FUNCTION_DECLARATION: 
            case PARAMETER: 
            case INTERFACE: 
            case PROTOCOL: 
            case STRUCT: 
            case LOCAL_VARIABLE: 
            case FUNCTION_PREDECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return false;
            }
        }
        return super.startInWriteAction();
    }
}

