/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractAssignmentIntentionAction
extends OCPsiElementQuickFix<OCExpression> {
    private SmartPsiElementPointer myLeftOperandPtr;

    public OCExtractAssignmentIntentionAction(OCExpression expression2, OCExpression leftOperand2) {
        super(expression2);
        this.myLeftOperandPtr = OCElementUtil.createPsiElementPointer(leftOperand2);
    }

    @Override
    protected String getTextInternal() {
        return "Extract assignment";
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression2) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, OCStatement.class);
        return !(condStatement instanceof OCLoopStatement) || this.getLoopBlock(expression2) != null;
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull OCExpression expression2) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, OCStatement.class);
        if (condStatement == null) {
            return;
        }
        OCBlockStatement loopBlock = this.getLoopBlock(expression2);
        OCExpressionStatement statement2 = (OCExpressionStatement)OCElementFactory.statementFromText("1;", (PsiElement)file2);
        statement2.getExpression().replace(expression2);
        expression2.replace((PsiElement)OCElementUtil.getPsiElementByPointer(this.myLeftOperandPtr));
        if (loopBlock != null) {
            OCChangeUtil.add(loopBlock, statement2.copy());
        }
        condStatement = OCChangeUtil.ensureParentIsBlockStatement(condStatement);
        OCChangeUtil.addBefore(condStatement.getParent(), statement2, condStatement);
    }

    @Nullable
    private OCBlockStatement getLoopBlock(OCExpression expression2) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, OCStatement.class);
        if (condStatement instanceof OCLoopStatement) {
            OCStatement body2 = ((OCLoopStatement)condStatement).getBody();
            return body2 instanceof OCBlockStatement ? (OCBlockStatement)body2 : null;
        }
        return null;
    }
}

