/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCGenerateConstructorFix
implements IntentionAction {
    private final OCStructSymbol myClass;
    private boolean myAddParametersForBaseClasses;

    public OCGenerateConstructorFix(OCStructSymbol symbol, boolean addParametersForBaseClasses) {
        this.myClass = symbol;
        this.myAddParametersForBaseClasses = addParametersForBaseClasses;
    }

    @NotNull
    public String getText() {
        if (this.myAddParametersForBaseClasses) {
            return "Create constructor matching base class(es)";
        }
        return "Create default constructor in " + this.myClass.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.myClass);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        new OCGenerateConstructorHandler(){

            @Override
            @NotNull
            protected List<? extends OCStructSymbol> getParents(@NotNull PsiElement at) {
                return Collections.singletonList(OCGenerateConstructorFix.this.myClass);
            }

            @Override
            protected boolean addParametersForBaseClasses() {
                return OCGenerateConstructorFix.this.myAddParametersForBaseClasses;
            }

            @Override
            protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
                return false;
            }

            @Override
            @NotNull
            protected Condition<OCDeclaratorSymbol> getCandidatesFilter(@NotNull OCGenerateConstructorContext actionContext) {
                return Conditions.alwaysFalse();
            }
        }.invoke(project2, null, file2);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

