/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class OCImplementInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private OCInterfaceSymbol myInterface;

    public OCImplementInterfaceIntentionAction(OCInterfaceSymbol anInterface) {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.implementation.title", new Object[0]), OCBundle.message("create.implementation.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myInterface = anInterface;
    }

    @NotNull
    public String getText() {
        if (this.myInterface == null) {
            return "Invalid";
        }
        return "Create implementation of " + this.myInterface.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        return "Implementation";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myInterface);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project2, file2.getParent(), file2, this.myInterface.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected String getFileTemplate(String fileName) {
        return "Objective-C Class.m";
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(selectedName + ".m", null);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project2) {
        VirtualFile file2 = this.myInterface.getContainingFile();
        OCLog.LOG.assertTrue(file2 != null);
        properties.setProperty("HEADER_FILENAME", file2.getName());
    }

    @NotNull
    protected CreateImplementationDialog createDialog(@NotNull String defaultName) {
        return new CreateImplementationDialog(defaultName);
    }

    protected class CreateImplementationDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateImplementationDialog(String defaultName) {
            super(OCImplementInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

