/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplateExpression;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInsertCastIntentionAction
extends OCPsiElementQuickFix<OCExpression> {
    private OCType myType;
    private boolean myInsertBridgeCast;

    public OCInsertCastIntentionAction(OCExpression expression2, OCType type2, boolean insertBridgeCast) {
        super(expression2);
        if (type2 instanceof OCPointerType && type2.isPointerToObject() && ((OCPointerType)type2).getARCAttribute() != null) {
            type2 = OCPointerType.to(((OCPointerType)type2).getRefType());
        }
        this.myType = type2;
        this.myInsertBridgeCast = insertBridgeCast;
    }

    public OCInsertCastIntentionAction(OCExpression expression2, OCType type2) {
        this(expression2, type2, false);
    }

    @Override
    protected String getTextInternal() {
        return "Cast expression to '" + this.myType.getName(this.myElementPtr.getElement()) + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Cast expression";
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression2) {
        return this.myType != null;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        int index;
        OCExpression operand2;
        OCCastExpression castExpr;
        String typeElementText;
        OCExpression expression2 = (OCExpression)this.myElementPtr.getElement();
        String string = typeElementText = this.myInsertBridgeCast ? "(__bridge int)" : "(int)";
        if (expression2 == null) {
            return;
        }
        if (expression2 instanceof OCBinaryExpression || expression2 instanceof OCConditionalExpression) {
            castExpr = (OCCastExpression)OCElementFactory.expressionFromText(typeElementText + "(1)", expression2);
            operand2 = ((OCParenthesizedExpression)castExpr.getOperand()).getOperand();
        } else {
            castExpr = (OCCastExpression)OCElementFactory.expressionFromText(typeElementText + "1", expression2);
            operand2 = castExpr.getOperand();
        }
        castExpr.getTypeElement().replace(OCElementFactory.typeElementFromText(this.myType.getName(expression2), (PsiElement)file2));
        PsiElement parent = expression2.getParent();
        PsiElement[] children2 = parent.getChildren();
        for (index = 0; index < children2.length && children2[index] != expression2; ++index) {
        }
        OCChangeUtil.replaceHandlingMacros(operand2, parent.copy().getChildren()[index]);
        castExpr = (OCCastExpression)OCChangeUtil.replaceHandlingMacros(expression2, castExpr);
        if (this.myInsertBridgeCast && !ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)expression2.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PsiElement element = castExpr.getNode().getChildren(OCTokenTypes.BRIDGE_CAST_KEYWORDS)[0].getPsi();
            TemplateBuilderImpl builder = new TemplateBuilderImpl(element);
            Object[] types = OCTokenTypes.BRIDGE_CAST_KEYWORDS.getTypes();
            builder.replaceElement(element, (Expression)new OCTemplateExpression("__bridge", (String[])ContainerUtil.map((Object[])types, type2 -> ((OCElementType)((Object)type2)).getName(), (Object[])new String[0])));
            builder.run();
        }
    }
}

